//
//  Cell_InfoImage2.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/16.
//

import UIKit

class Cell_InfoImage2: UITableViewCell {
    @IBOutlet weak var bgView1: UIView!
    @IBOutlet weak var btn_add1: UIButton!
    @IBOutlet weak var img_1: UIImageView!

    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
        let tap1 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_1.addGestureRecognizer(tap1)
        img_1.isUserInteractionEnabled = true
    }
    
    
    @objc func imageChange(_ sender:UITapGestureRecognizer){
        if sender.view == img_1{
            callBack?(1)
        }
       
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    @IBAction func addAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
}

extension Cell_InfoImage2: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
       
    }
    
    func row_update(dataSource data: (String)) {
        if data != ""{
            btn_add1.isHidden = true
            img_1.sd_setImage(with: URL(string: data))
            
        }else{
            img_1.sd_setImage(with: URL(string: ""))
            btn_add1.isHidden = false
        }
        
        img_1.layer.cornerRadius = 8
        img_1.layer.masksToBounds = true
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}



