//
//  Cell_InfoRow.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/12.
//

import UIKit

class Cell_InfoRow: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var bgViewLeadingC: NSLayoutConstraint!
    @IBOutlet weak var bgViewTrailingC: NSLayoutConstraint!
    @IBOutlet weak var iconView: UIView!
    @IBOutlet weak var iconImgView: UIImageView!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var infoLabel: UILabel!
    @IBOutlet weak var nextView: UIView!
    @IBOutlet weak var nextImageView: UIImageView!
    @IBOutlet weak var lineView: UIView!
    @IBOutlet weak var titleLabelWLC: NSLayoutConstraint!
    
    var infoColor = UIColor(hexString: "#666666")
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        nextImageView.image = UIImage(named: "mine_btn_next")
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}

extension Cell_InfoRow: TCCell_RowCellUpdateProtocol {
    // value、placeholder
    typealias DataSource = (CGFloat?, String, String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
    
        bgView.backgroundColor = data.bgColor
        self.backgroundColor = data.cellColor
        bgViewLeadingC.constant = data.bgViewLeading ?? 0
        bgViewTrailingC.constant = data.bgViewTrailing ?? 0
        
        bgView.makeLayerRadius(value: data.cornerRadius ?? 0.0, type: data.cornerMask ?? [.layerMaxXMaxYCorner,.layerMaxXMinYCorner,.layerMinXMaxYCorner,.layerMinXMinYCorner])
        iconView.isHidden = !data.showIconView
        iconImgView.image = data.iconImage
        titleLabel.textColor = data.titleColor
        titleLabel.textAlignment = data.titleAlignment
        titleLabel.font = data.titleFont
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
//            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            showStr.insert(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]), at: 0)
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        infoLabel.textAlignment = data.textAlignment
        lineView.isHidden = !data.showLineView
        nextView.isHidden = !data.showNextView
        
        infoLabel.textColor = data.infoColor
        infoColor = data.infoColor
        infoLabel.font = data.infoFont
        
        nextImageView.image = UIImage(named: data.nextViewImageStr)
    }
    
    func row_update(dataSource data: (CGFloat?, String, String)) {
        titleLabelWLC.constant = data.0 ?? 100
        if data.1.isEmpty {
            // 提示文本颜色
            infoLabel.textColor = UIColor(hexString: "cccccc")
            infoLabel.text = data.2
        }else{
            infoLabel.textColor = infoColor
            infoLabel.text = data.1
        }
    }
    
}

