//
//  Cell_MineEngineerList.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/16.
//

import UIKit

class Cell_MineEngineerList: UITableViewCell {

    @IBOutlet weak var btn_icon: UIButton!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_mobile: UILabel!
    @IBOutlet weak var lab_date: UILabel!
    
    @IBOutlet weak var btn_state: UIButton!
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        self.btn_state.contentEdgeInsets = UIEdgeInsets(top: 5,left: 5, bottom: 5,right: 5);
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_MineEngineerList: TCCell_RowCellUpdateProtocol {

    typealias DataSource = ([String:Any])
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
       
    }
    
    func row_update(dataSource data: ([String:Any])) {
        lab_name.text = data.stringValue(forKey: "engineerName")
        lab_mobile.text = data.stringValue(forKey: "engineerMobile")
        lab_date.text = "有效期".languageString()+data.stringValue(forKey: "endDate")
        btn_state.setTitle(data.stringValue(forKey: "limitTakeOrderName"), for: .normal)
        
        let pic = kGetServerPicUrl(data.stringValue(forKey: "engineerPic"))
       
        btn_icon.sd_setImage(with: URL(string: pic), for: .normal, placeholderImage: UIImage(named: "pic_profile_man"), context: nil)
        
        if data.stringValue(forKey: "limitTakeOrderName").contains("禁"){
            btn_state.backgroundColor = hexColor(hex: "FAECEB")
            btn_state.setTitleColor(hexColor(hex: "E04A42"), for: .normal)
        }else{
            btn_state.backgroundColor = hexColor(hex: "EDFAF2")
            btn_state.setTitleColor(hexColor(hex: "31C97E"), for: .normal)
        }
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}
