//
//  Cell_MineHeader.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/11.
//

import UIKit

class Cell_MineHeader: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var btn_icon: UIButton!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var width_name: NSLayoutConstraint!
    @IBOutlet weak var btn_isReal: UIButton!
    @IBOutlet weak var lab_company: UILabel!
    
    @IBOutlet weak var cardView: UIView!
    
    @IBOutlet weak var btn_showInfo: UIButton!
    @IBOutlet weak var lab_myInfo: UILabel!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        
        let image1 = UIImage(named: "mine_bg")
        self.bgView.layer.contents = image1?.cgImage
        
        let image2 = UIImage(named: "mine_bg_card")
        self.cardView.layer.contents = image2?.cgImage
        
        if MyInfo.shareInstance().userRole == .Admin {
            self.cardView.isHidden = true
        }
        
        
        lab_myInfo.text = "我的资料".languageString()
        btn_showInfo.setTitle("查看".languageString(), for: .normal)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func showIconAction(_ sender: UIButton) {
        callBack?("查看头像")
    }
    
    @IBAction func showInfoAction(_ sender: UIButton) {
        callBack?("查看信息")
    }
    
}


extension Cell_MineHeader: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String,String,String,String)) {
        lab_name.text = data.0
        lab_company.text = "所属服务商：".languageString()+data.1
        btn_icon.sd_setImage(with: URL(string: data.2), for: .normal, placeholderImage: UIImage(named: "pic_profile_man"), context: nil)
        
        //lab_name 宽度计算
        var width:CGFloat = 50
        let pad = 18
        let count = data.0.count
        if data.0.count > 0{
            width = CGFloat(count * pad)
            if width < 50 {
                width = 50
            }
            
            if width > 250 {
                width = 250
            }
            
            width_name.constant = width
            self.updateConstraints()
        }
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}
