//
//  Cell_MineTitle.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/11.
//

import UIKit

class Cell_MineTitle: UITableViewCell {

    @IBOutlet weak var btn_icon: UIButton!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var icon_right: UIImageView!
    @IBOutlet weak var lineView: UIView!
    
    //版本更新row
    @IBOutlet weak var lab_info: UILabel!
    @IBOutlet weak var tipView: UIView!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_MineTitle: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        tipView.isHidden = !data.showTipLabel //显示版本红点
    }
    
    func row_update(dataSource data: (String,String,String)) {
        lab_title.text = data.0
        btn_icon.setImage(UIImage(named: data.1), for: .normal)
        
        lab_info.text = data.2
        lab_info.isHidden = data.2 == ""
    }
    
    func row_update(callBack block: TCRowCallBack?) {
       
    }
    
}
