//
//  MineHomeVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/22.
//

import UIKit
import MJRefresh

class MineHomeVc: UIViewController {

    @IBOutlet weak var tableView: UITableView!
    
    var vm = MineHomeVm()
    
    lazy var topBar: CD_TopBar = {
        return CD_TopBar()
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.cd.navigationBar(hidden: true)
        self.view.cd
            .add(topBar)
        topBar.snp.makeConstraints { (make) in
            make.left.top.right.equalToSuperview()
        }
        tableView.snp.makeConstraints { (make) in
            make.top.equalTo(self.topBar.snp.bottom).offset(0)
            make.left.bottom.right.equalToSuperview()
        }
        topBar._colorTitle = UIColor.white
        topBar._colorSubTitle = UIColor.white
        topBar.delegate = self
        
        configTableView()
        getVersion()
    }
    
    func getVersion(){
        let infoDictionary = Bundle.main.infoDictionary
        guard let majorVersion = infoDictionary?.stringForKey("CFBundleShortVersionString") else {return}

        vm.majorVersion = "\(majorVersion)"
        vm.makeForms()
    }
   
    func configTableView() {
     
        self.tableView.backgroundColor = UIColor(hexString: "f8f8f8")
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.delegate = self
        tableView.dataSource = self
        tableView.isScrollEnabled = false
        tableView.separatorStyle = .none
        vm.callback = {
            self.tableView.reloadData()
        }
        vm.makeForms()
        
//        let header = MJRefreshNormalHeader()
//        header.setRefreshingTarget(self, refreshingAction: #selector(headerRefresh))
//        tableView.mj_header = header
    }

}

//网络请求
extension MineHomeVc{
    //mark refresh
    @objc func headerRefresh(){
        self.tableView.mj_header.endRefreshing()
    }
    
}


extension MineHomeVc: CD_TopBarProtocol {
    func topBarCustom() {
        topBar._style = "10"
        let image1 = UIImage(named: "mine_nav_bg")
        topBar.layer.contents = image1?.cgImage
        topBar._title = ""
        topBar._colorTitle = UIColor.white
        topBar._colorSubTitle = UIColor.white
        topBar.bar_navigation.line.cd.isHidden(true)
    }
    
    func update(withTopBar item: CD_TopNavigationBar.Item) -> [CD_TopNavigationBarItem.Item.Style]? {
        switch item {
        case .leftItem1:
            let color:UIColor = Config.color.hex("f")
            let icon = CD_IconFont.tback_light(22)
            return [.title([(icon.text, icon.font, color, .normal), (icon.text, icon.font, Config.color.hex("f"), .highlighted), (icon.text, icon.font, Config.color.hex("f"), .selected)])]
        default:
            return nil
        }
    }
    
    func didSelect(withTopBar item: CD_TopNavigationBar.Item) {
        super_topBarClick(item)
        switch item {
        case .leftItem1:
            break
        case .rightItem1:
           debugPrint("全部搜索")
            let vc = UIStoryboard(name: "Home", bundle: nil).instantiateViewController(withIdentifier: "HomeOrderListSearchVc") as! HomeOrderListSearchVc
            self.navigationController?.pushViewController(vc, animated: true)
            break
        default:
            break
        }
    }
}


// MARK: - Table view data source
extension MineHomeVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}

