//
//  MineInfoMainVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/12.
//

import UIKit
import JXSegmentedView

class MineInfoMainVc: UIViewController {
    var currentIndex = 0
    
    lazy var headView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var childVcView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        if MyInfo.shareInstance().userRole == .Site {
            segmentedDa.titles = ["基础信息".languageString(),"财务信息".languageString(), "资质认证".languageString()]
        }
        if MyInfo.shareInstance().userRole == .Engineer {
            segmentedDa.titles = ["基础信息".languageString(), "资质认证".languageString()]
        }
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = UIColor(hexString: "#666666")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = UIColor(hexString: "#333333")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = UIColor(hexString: "#478BFF")
        indicator.indicatorWidth = 24
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    
    lazy var topBar: CD_TopBar = {
        return CD_TopBar()
    }()
    
    var model = M_MineInfo(json: [:])
 
    var subViewVc1 = MineInfoVc()
    var subViewVc2 = MineFinanceVc()
    var subViewVc3 = MineCertificatePicVc()
    
    var canEdit = true
    var isBusy = false
    
    var updateCallback:(()->())?
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "我的信息".languageString()
        setNavigationBackButton()
        configUI()
      
        self.requstGetData()
    }
    
    func configUI() {
        self.cd.navigationBar(hidden: true)
        self.view.cd
            .add(topBar)
            .add(headView)
            .add(childVcView)
        
        topBar.delegate = self
        
        segmentedView.defaultSelectedIndex = currentIndex
        segmentedDataSource.reloadData(selectedIndex: currentIndex)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        
        topBar.snp.makeConstraints { (make) in
            make.left.top.right.equalToSuperview()
        }
        
        headView.snp.makeConstraints { (make) in
            make.top.equalTo(self.topBar.snp.bottom)
            make.left.right.equalToSuperview()
            make.height.equalTo(50)
        }
        
        headView.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(48)
        }
        childVcView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(headView.snp.bottom)
        }
        segmentedView.listContainer = listContainerView
        childVcView.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
         }
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        do {
            subViewVc1 = MineInfoVc()
            subViewVc1.vm.model = model
            cSubC.append(subViewVc1)
        }
        
        //服务商
        if MyInfo.shareInstance().userRole == .Site {
            do {
                subViewVc2 = MineFinanceVc()
                subViewVc2.vm.model = model
                cSubC.append(subViewVc2)
            }
        }
        
        do {
            subViewVc3 = UIStoryboard(name: "Mine", bundle: nil).instantiateViewController(withIdentifier: "MineCertificatePicVc") as! MineCertificatePicVc
            subViewVc3.vm.model = model
            subViewVc3.updateCallback = { (newModel) in
                self.model = newModel
                self.updateChildControllersData()
            }
            cSubC.append(subViewVc3)
        }
    
        subControllerList = cSubC
    }
    
    
    func updateChildControllersData(){
        subViewVc1.vm.model = self.model
        subViewVc2.vm.model = self.model
    }

}

//请求
extension MineInfoMainVc{
    func requstGetData(){
       
        var param = [String:Any]()
        
        SVProgressHUD.show()
        let cNet = TWOCNetwork(url: "/app/v2/personal/myInformation",andParam: param)
        cNet.successCall = { [weak self] (result) in
            SVProgressHUD.dismiss()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                let model = M_MineInfo(json: data)
                weakSelf.model = model
                weakSelf.addSubViewControlls()
                weakSelf.listContainerView.reloadData()
            }
        }
        cNet.failCall = {(errorTag,errorStr) in
            SVProgressHUD.dismiss()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
    
}

extension MineInfoMainVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {

    }
}


extension MineInfoMainVc: CD_TopBarProtocol {
    func topBarCustom() {
        topBar.cd.background(.clear)
        topBar._title = "我的资料".languageString()
        topBar._colorTitle = Config.color.hex("3")
        topBar.bar_navigation.line.cd.isHidden(false)
        topBar._style = "10"
    }
    
    func update(withTopBar item: CD_TopNavigationBar.Item) -> [CD_TopNavigationBarItem.Item.Style]? {
        switch item {
        case .leftItem1:
            let color:UIColor = Config.color.hex("6")
            let icon = CD_IconFont.tback_light(22)
            return [.title([(icon.text, icon.font, color, .normal), (icon.text, icon.font, Config.color.hex("6"), .highlighted), (icon.text, icon.font, Config.color.hex("6"), .selected)])]
        default:
            return nil
        }
    }
    
    func didSelect(withTopBar item: CD_TopNavigationBar.Item) {
        super_topBarClick(item)
        switch item {
        case .leftItem1:
            break
        default:
            break
        }
    }
}
