//
//  MineFinanceVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/12.
//

import UIKit

class MineFinanceVm: NSObject {
    
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var model = M_MineInfo(json: [:])
    func makeForms(){
        var newForms:[TCCellBaseProtocol] = []
      
        newForms += makeInfoForms()
        
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("财务信息".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("开户银行".languageString(), value: model.siteBankName))
        newForms.append(self.makeTextLineCell("银行账户".languageString(), value: model.siteBankAccountName))
        newForms.append(self.makeTextLineCell("银行账号".languageString(), value: model.siteBankAccount))
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
    func makeTextLineCell(_ title:String,value:String)->TCCellBaseProtocol {
        let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
            .title(title)
            .titleFont(UIFont.systemFont(ofSize: 14))
            .titleColor(UIColor(hexString: "#999999"))
            .infoFont(UIFont.systemFont(ofSize: 14))
            .infoColor(UIColor(hexString: "333333"))
            .showNext(false)
            .showLine(false)
            .textAlignment(.right)
        let rowCell = TCFormCellModel<Cell_InfoRow>.init(data: (70, value, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
        })
        
        return rowCell
    }
    
}
