//
//  MineHomeVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/11.
//

import UIKit

class MineHomeVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    
    var majorVersion = ""
    func makeForms(){
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeHeaderForms()
        newForms += makeRowForms()
    
        forms = newForms
        callback?()
    }
    
    
    func makeHeaderForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            
            var userName = MyInfo.shareInstance().userName
            var siteName = MyInfo.shareInstance().companyName
            
            if MyInfo.shareInstance().userRole == .Engineer {
                userName = MyInfo.shareInstance().userName
                siteName = MyInfo.shareInstance().siteName
            }
            
            var height:CGFloat = 167
            if MyInfo.shareInstance().userRole == .Admin {
                height = 110
            }
            
            let rowCell = TCFormCellModel<Cell_MineHeader>.init(data: (userName,siteName,MyInfo.shareInstance().userPic,""), config: uiConfigModel, id: nil, frameh: height) { a in
                if let actionStr = a as? String {
                    debugPrint(actionStr)
                    if actionStr == "查看信息"{
                        let infoVc = UIStoryboard(name: "Mine", bundle: nil).instantiateViewController(withIdentifier: "MineInfoMainVc") as! MineInfoMainVc
                        infoVc.hidesBottomBarWhenPushed = true
                        CD.visibleVC?.navigationController?.pushViewController(infoVc, animated: true)
                    }
                }
            }
            newForms.append(rowCell)
        }
        return newForms
    }
    
    func makeRowForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        if MyInfo.shareInstance().userRole == .Engineer {
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                uiConfigModel.showTip(false)
                let rowCell = TCFormCellModel<Cell_MineTitle>.init(data: ("电子工牌".languageString(),"mine_icon_badge",""), config: uiConfigModel, id: nil, frameh: 50, didSelect:  {
                    //查看
                    
                    let requsetUrl = TWOCNetwork.shareNetManager().baseURL+"/h5/workCard.html"
                    let webUrl = requsetUrl + "?siteId="+MyInfo.shareInstance().siteId+"&engineerId="+MyInfo.shareInstance().engineerId+"&token="+MyInfo.shareInstance().token
                    R_Web.push(.http(webUrl), title: "电子工牌".languageString())
                    
                })
                newForms.append(rowCell)
            }
        }
        
        if MyInfo.shareInstance().userRole == .Site {
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                uiConfigModel.showTip(false)
                let rowCell = TCFormCellModel<Cell_MineTitle>.init(data: ("工程师管理".languageString(),"mine_icon_engineer",""), config: uiConfigModel, id: nil, frameh: 50, didSelect:  {
                    //查看
                  let vc = UIStoryboard(name: "Mine", bundle: nil).instantiateViewController(withIdentifier: "MineEngineerListVc") as! MineEngineerListVc
                    vc.hidesBottomBarWhenPushed = true
                 CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
                    
                })
                newForms.append(rowCell)
            }
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            uiConfigModel.showTip(false)
            let rowCell = TCFormCellModel<Cell_MineTitle>.init(data: ("更多设置".languageString(),"mine_icon_set",""), config: uiConfigModel, id: nil, frameh: 50, didSelect:  {
                //查看
                R_MineSetting.router()
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            uiConfigModel.showTip(MyInfo.shareInstance().downloadShow != "")
            let rowCell = TCFormCellModel<Cell_MineTitle>.init(data: ("版本更新".languageString(),"mine_icon_version",majorVersion), config: uiConfigModel, id: nil, frameh: 50, didSelect:  {
                //查看
                
            })
            newForms.append(rowCell)
        }
        
        
        return newForms
    }
}
