//
//  MineInfoVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/12.
//

import UIKit

class MineInfoVm: NSObject {
    
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var model = M_MineInfo(json: [:])
    func makeForms(){
        var newForms:[TCCellBaseProtocol] = []
      
        newForms += makeInfoForms()
        newForms += makeContactForms()
        
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("基本信息".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        if MyInfo.shareInstance().userRole == .Engineer {
            newForms.append(self.makeTextLineCell("登陆账号".languageString(), value: model.engineerName))
            newForms.append(self.makeTextLineCell("名    称".languageString(), value: model.engineerName))
            newForms.append(self.makeTextLineCell("所属网点".languageString(), value: model.engineerSiteName))
            newForms.append(self.makeTextLineCell("手机号码".languageString(), value: model.engineerMobile))
            newForms.append(self.makeTextLineCell("在职状态".languageString(), value: model.engineerPostStatName))
            
            newForms.append(self.makeTextLineCell("认证等级".languageString(), value: model.engineerAuthLevelName))
            newForms.append(self.makeTextLineCell("派单状态".languageString(), value: model.engineerLimitTakeOrderName))
            newForms.append(self.makeTextLineCell("星     级".languageString(), value: model.engineerStarRatingName))
        }
        
        if MyInfo.shareInstance().userRole == .Site {
            newForms.append(self.makeTextLineCell("登陆账号".languageString(), value: model.siteUserAccount))
            newForms.append(self.makeTextLineCell("运营状态".languageString(), value: model.siteBusinessStatName))
            newForms.append(self.makeTextLineCell("名    称".languageString(), value: model.siteUserName))
            newForms.append(self.makeTextLineCell("手机号码".languageString(), value: model.siteUserMobile))
            newForms.append(self.makeTextLineCell("状    态".languageString(), value: model.siteStatName))
            newForms.append(self.makeTextLineCell("上级网点".languageString(), value: model.siteParentSiteName))
            
            newForms.append(self.makeTextLineCell("服务中心".languageString(), value: model.siteOrgName))
            newForms.append(self.makeTextLineCell("网点性质".languageString(), value: model.siteTypeName))
        }
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
    func makeContactForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("联系信息".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        if MyInfo.shareInstance().userRole == .Engineer {
            newForms.append(self.makeTextLineCell("所在地区".languageString(), value: model.engineerTown))
            newForms.append(self.makeTextLineCell("详细地址".languageString(), value: model.engineerAddress))
            newForms.append(self.makeTextLineCell("身份证号".languageString(), value: model.engineerPid))
        }
        
        if MyInfo.shareInstance().userRole == .Site {
            newForms.append(self.makeTextLineCell("所在地区".languageString(), value: model.siteUserAreaName))
            newForms.append(self.makeTextLineCell("详细地址".languageString(), value: model.siteUserAddress))
            newForms.append(self.makeTextLineCell("身份证号".languageString(), value: model.siteLegalPersonId))
            newForms.append(self.makeTextLineCell("联系人".languageString(), value: model.siteMan))
        }
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
    func makeTextLineCell(_ title:String,value:String)->TCCellBaseProtocol {
        let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
            .title(title)
            .titleFont(UIFont.systemFont(ofSize: 14))
            .titleColor(UIColor(hexString: "#999999"))
            .infoFont(UIFont.systemFont(ofSize: 14))
            .infoColor(UIColor(hexString: "333333"))
            .showNext(false)
            .showLine(false)
            .textAlignment(.right)
        let rowCell = TCFormCellModel<Cell_InfoRow>.init(data: (70, value, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
        })
        
        return rowCell
    }
    
}
