//
//  MineSettingVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/17.
//

import UIKit

class MineSettingVm: NSObject {
    
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var mobile = ""
    func makeForms(){
        var newForms:[TCCellBaseProtocol] = []
      
        newForms += makeInfoForms()
        newForms += makeOtherForms()
        
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("安全设置".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("修改手机号".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showTip(false)
                .showLine(true)
                .textAlignment(.right)
            
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (100, mobile, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
                R_MineUpdate.router("修改手机号",mobile: weakSelf.mobile)
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("修改密码".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showTip(false)
                .showLine(false)
                .textAlignment(.left)
            
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (100, "", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
                R_MineUpdate.router("修改密码")
            })
            newForms.append(rowCell)
        }
        
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
    func makeOtherForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("其他设置".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("用户协议".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "999999"))
                .showNext(true)
                .showTip(false)
                .showLine(true)
                .textAlignment(.right)
            
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (100, "查看".languageString(), ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
                let requsetUrl = TWOCNetwork.shareNetManager().baseURL+"/h5/userPolicy.html"
                let webUrl = requsetUrl + "?siteId="+MyInfo.shareInstance().siteId+"&engineerId="+MyInfo.shareInstance().engineerId+"&token="+MyInfo.shareInstance().token
                R_Web.push(.http(webUrl), title: "用户协议".languageString())
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("隐私协议".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "999999"))
                .showNext(true)
                .showTip(false)
                .showLine(true)
                .textAlignment(.right)
            
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (100, "查看".languageString(), ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
            
                let requsetUrl = TWOCNetwork.shareNetManager().baseURL+"/h5/privacyPolicy.html"
                let webUrl = requsetUrl + "?siteId="+MyInfo.shareInstance().siteId+"&engineerId="+MyInfo.shareInstance().engineerId+"&token="+MyInfo.shareInstance().token
                R_Web.push(.http(webUrl), title: "隐私协议".languageString())
            })
            newForms.append(rowCell)
        }
        
//        do {
//            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
//                .title("隐私设置")
//                .titleFont(UIFont.systemFont(ofSize: 14))
//                .titleColor(UIColor(hexString: "666666"))
//                .infoFont(UIFont.systemFont(ofSize: 14))
//                .infoColor(UIColor(hexString: "999999"))
//                .showNext(true)
//                .showTip(false)
//                .showLine(true)
//                .textAlignment(.right)
//            
//            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (100, "", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
//                guard let weakSelf = self else { return }
//            
//            })
//            newForms.append(rowCell)
//        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("第三方信息共享清单".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "999999"))
                .showNext(true)
                .showTip(false)
                .showLine(false)
                .textAlignment(.right)
            
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (150, "", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
            
                let requsetUrl = TWOCNetwork.shareNetManager().baseURL+"/h5/informationSharing.html"
                let webUrl = requsetUrl + "?siteId="+MyInfo.shareInstance().siteId+"&engineerId="+MyInfo.shareInstance().engineerId+"&token="+MyInfo.shareInstance().token
                R_Web.push(.http(webUrl), title: "第三方信息共享清单".languageString())
            })
            newForms.append(rowCell)
        }
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
}
