//
//  MineUpdateVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/17.
//

import UIKit

class MineUpdateVm: NSObject {
    
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    
    var getCodeCallback:((String)->())?
    var submitCallback:(()->())?
    var style = ""
    //修改手机号
    var mobile = ""
    var newMobile = ""
    var code = ""
    
    //修改密码
    var old = ""
    var password1 = ""
    var password2 = ""
    
    func makeForms(){
        var newForms:[TCCellBaseProtocol] = []
        if style == "修改手机号" {
            newForms += makeChangeMobileForms()
        }else{
            newForms += makeChangePasswordForms()
        }
    
        forms = newForms
        callback?()
    }
    
    func makeChangeMobileForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("现手机号".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(false)
                .showTip(false)
                .showLine(true)
                .textAlignment(.left)
            
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (67, mobile, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                guard let weakSelf = self else { return }
            
            })
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "新手机号".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, newMobile, "请输入".languageString(), nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.newMobile = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let value = code
            let rowCell = TCFormCellModel<Cell_FindPasswordGetCode>.init(data: ("",value,"请输入".languageString()), config: uiConfigModel, id: nil, frameh: 50, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.code = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
                
                if let actionStr = callValue as? String{
                    self?.getCodeCallback?("获取验证码")
                }
            })

            newForms.append(rowCell)
        }
        
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 30)
            newForms.append(rowCell)
        }
        
        //保存按钮TCSubmitButtonCell
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().bgColor(UIColor(hexString: "f8f8f8")).setCellColor(UIColor(hexString: "f8f8f8"))
            let rowCell = TCFormCellModel<TCSubmitButtonCell>.init(data: (false, "","提交".languageString(), UIColor(hexString: "ffffff"), 60, nil), config: uiConfigModel, id: nil, frameh: 50) { a in
                //提交
                self.submitCallback?()
            }
            newForms.append(rowCell)
        }
        
       return newForms
    }
    
    func makeChangePasswordForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        //内容
       
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "原密码".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, old, "请输入".languageString(), nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.old = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
       
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "新密码".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, password1, "请输入".languageString(), nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.password1 = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "再次输入".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .infoColor(UIColor(hexString: "#333333"))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, password2, "请输入".languageString(), nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.password2 = cValue.1
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do{
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("")
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "#478BFF"))
                .showNext(false)
                .showLine(false)
                .textAlignment(.right)
            let rowCell = TCFormCellModel<Cell_InfoRow>.init(data: (200, "", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
            })
        }
    
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 30)
            newForms.append(rowCell)
        }
        
        //保存按钮TCSubmitButtonCell
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().bgColor(UIColor(hexString: "f8f8f8")).setCellColor(UIColor(hexString: "f8f8f8"))
            let rowCell = TCFormCellModel<TCSubmitButtonCell>.init(data: (false, "","提交".languageString(), UIColor(hexString: "ffffff"), 60, nil), config: uiConfigModel, id: nil, frameh: 50) { a in
                //提交
                self.submitCallback?()
            }
            newForms.append(rowCell)
        }

        
       return newForms
    }
    
}
