//
//  M_OrderDetailInfo.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/29.
//

import Foundation

class M_OrderDetailInfo: NSObject {
    
    var orderId = ""      //工单ID
    var userName = ""      //用户姓名
    var userAddress = ""      //地址
    var lat = ""         //用户地址纬度
    var lnt = ""         //用户地址经度
    var userMobile = ""
    var distance = ""      //距离[后台返回时已经带上了KM单位]
    var guaranteeTypeName = ""      //保修类型名称
    var serviceTypeName = ""      //服务类型名称
    var isUrgent = 0      //是否加急:0否1是
    var itemList:[Item] = []//工单产品列表
        
    var orderNo = ""      //工单号
    var orderStat = 0      //工单状态
    var orderStatName = ""      //工单状态名称
    var takeTime = ""      //派工时间
    var wishBookDate = ""      //用户期望上门时间
    var bookDate = ""      //预约上门时间[后台返回时要带上时间段字段]
    var bookDateShow = ""      //预约上门日期
    var bookDatePeriod = ""    //预约上门时间
    var appeals = ""      //服务诉求

    var showDataList:[ShowData] = []//动态显示字段(前端依次显示showDateList里的字段名及值)
         

    //因为每个企业,每种单据,每个用户的操作都是不一样,或者后期会新增新的操作按钮,为了简化前端对操作按钮的控制,将逻辑放到后台来处理,由后台返回可展示的操作按钮列表,前端依次显示出来(但是每个按钮绑定的跳转页面只能在前端根据buttonCode写死)
    var operateButtonList:[OperateButton] = []//其他操作按钮列表(前端依次显示buttonName)
         

    var timeLable = ""      //时间标签
    //与上面其他操作按钮的原因一样,主操作按钮也由后台返回,前端根据buttonCode来跳转到对应的页面即可(但如果mainButtonType=2时,则跳转到mainButtonSkipH5Page指向的页面,主要是为了满足自定义工单流程的场景);如果后台未返回mainButtonCode,则表示没有任何主操作按钮.
    var mainButtonType = 1      //主操作按钮类型:1常规;2 自定义H5页面
    var mainButtonCode = ""      //主操作按钮编码);mainButtonType=2时,Code固定为”0“
    var mainButtonName = ""      //主操作按钮名称
    var mainButtonSkipH5Page = ""      //mainButtonType=2时的跳转H5页面

    //以下为对“服务过程”的数据处理逻辑
    var processType = 1      //过程类型:1常规;2 自定义
    var processList:[Process] = []//节点列表
    

    //以上为隐藏字段
    var insurePage = ""      //保险理赔跳转页面地址

    var startOffLnt = ""          //出发地址经度
    var startOffLat = ""          //出发地址纬度
    var startOffLocation = ""         //出发地址
    var startOffTime = ""         //出发时间
    var notMaintainedAK = 0       //
    init(_ data:[String:Any] = [:]) {
        orderId = data.stringValue(forKey: "orderId")
        userName = data.stringValue(forKey: "userName")
        userAddress = data.stringValue(forKey: "userAddress")
        userMobile = data.stringValue(forKey: "userMobile")
        distance = data.stringValue(forKey: "distance")
        lat = data.stringValue(forKey: "lat")
        lnt = data.stringValue(forKey: "lnt")
        guaranteeTypeName = data.stringValue(forKey: "guaranteeTypeName")
        serviceTypeName = data.stringValue(forKey: "serviceTypeName")
        isUrgent = data.intValue(forKey: "isUrgent")
        itemList = data.arrayValue(forKey: "itemList").compactMap({Item($0)})
            
        orderNo = data.stringValue(forKey: "orderNo")
        orderStat = data.intValue(forKey: "orderStat")
        orderStatName = data.stringValue(forKey: "orderStatName")
        takeTime = data.stringValue(forKey: "takeTime")
        wishBookDate = data.stringValue(forKey: "wishBookDate")
        bookDate = data.stringValue(forKey: "bookDate")
        bookDateShow = data.stringValue(forKey: "bookDateShow")
        bookDatePeriod = data.stringValue(forKey: "bookDatePeriod")
        appeals = data.stringValue(forKey: "appeals")

        showDataList = data.arrayValue(forKey: "showDataList").compactMap({ShowData($0)})
             
        operateButtonList = data.arrayValue(forKey: "operateButtonList").compactMap({OperateButton($0)})
        
        timeLable = data.stringValue(forKey: "timeLable")
        
        mainButtonType = data.intValue(forKey: "mainButtonType")
        mainButtonCode = data.stringValue(forKey: "mainButtonCode")
        mainButtonName = data.stringValue(forKey: "mainButtonName")
        mainButtonSkipH5Page = data.stringValue(forKey: "mainButtonSkipH5Page")

        processType = data.intValue(forKey: "processType")
        processList = data.arrayValue(forKey: "processList").compactMap({Process($0)})
        
        insurePage = data.stringValue(forKey: "insurePage")
        
        startOffLnt = data.stringValue(forKey: "startOffLnt")
        startOffLat = data.stringValue(forKey: "startOffLat")
        startOffTime = data.stringValue(forKey: "startOffTime")
        startOffLocation = data.stringValue(forKey: "startOffLocation")
        
        notMaintainedAK = data.intValue(forKey: "notMaintainedAK")
    }

}

extension M_OrderDetailInfo {
    struct Item {
        var orderLineId = ""      //工单明细ID
        var itemId = ""      //产品ID
        var categoryName = ""      //产品分类名称,大类名称/小类名称拼接
        var itemName = ""      //产品名称
        var qty = ""      //数量
        
        init(_ data:[String:Any]) {
            orderLineId = data.stringValue(forKey: "orderLineId")
            itemId = data.stringValue(forKey: "itemId")
            categoryName = data.stringValue(forKey: "categoryName")
            itemName = data.stringValue(forKey: "itemName")
            qty = data.stringValue(forKey: "qty")
        }
    }
    
    struct ShowData {
        var name = ""      //字段名
        var value = ""      //字段值
        
        init(_ data:[String:Any]) {
            name = data.stringValue(forKey: "name")
            value = data.stringValue(forKey: "value")
//            if !data.isEmpty {
//                name = data.first!.key
//                value = "\(data.first!.value)"
//            }
        }
    }
    
    struct OperateButton {
        var buttonCode = ""      //按钮编码//用于惟一标识操作类型
        var buttonName = ""      //按钮名称//同一个操作,不同的企业可能叫法上不一样
        
        init(_ data:[String:Any]) {
            buttonCode = data.stringValue(forKey: "buttonCode")
            buttonName = data.stringValue(forKey: "buttonName")
        }
    }
    
    struct Process {
        var orderId = ""      //工单id
        var processId = ""      //流程节点id
        var processName = ""      //节点名称
        var processStat = 1      //状态:1进行中;2暂存;5完成;9屏蔽
        var processTime = ""      //完成时间
        var content = ""      //内容
        
        init(_ data:[String:Any]) {
            orderId = data.stringValue(forKey: "orderId")
            processId = data.stringValue(forKey: "processId")
            processName = data.stringValue(forKey: "processName")
            processStat = data.intValue(forKey: "processStat")
            processTime = data.stringValue(forKey: "processTime")
            content = data.stringValue(forKey: "content")
        }
    }
}
