//
//  M_OrderPartsInfo.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/15.
//

import Foundation

class M_OrderPartsInfo: NSObject {
    var applyId = ""              //配件申请单ID
    var applyNo = ""              //配件申请单号
    var applyButton = ""              //申领配件按钮是否显示:0不显示1显示
    var stat = ""              //状态,如果配件申请单的stat为0或1时,则允许重新保存:在这两个状态下,界面上除了单号,状态,发出仓库,配送方式,物流信息,申请人,数量/金额这几个字段外,其余字段均可以修改;
    var statName = ""              //状态名称
    var deliverProvince = ""              //收货信息:省
    var deliverCity = ""              //收货信息:市
    var deliverCounty = ""              //收货信息:区
    var delieverTown = ""              //收货信息:镇
    var areaId = ""              //地区ID//前端不显示
    var deliverAddress = ""              //收货详细地址//前端需要增加显示
    var deliverMan = ""              //收货人//前端需要增加显示
    var deliverMobile = ""              //联系电话//前端需要增加显示
    var outType = ""              //发出类型:1总部;2区域;//前端需要增加显示
    var outTypeWarehouseList:[OutTypeWarehouse] = []          //发出类型与发出仓库对应List;在上面的发出类型切换时,发出仓库的可选值也需要切换为对应的仓库列表
    var outWarehouseId = ""              //发出仓库ID;//前端不显示
    var outWarehouseName = ""              //发出仓库名称);
    var deliverType = ""              //配送方式ID;//前端不显示
    var deliverTypeName = ""              //配送方式名称
    var createByAndDate = ""              //创建人/创建时间
    var qtyAndAmount = ""              //数据/金额
    var remark = ""              //备注
    var pic1 = ""              //图片1
    var pic2 = ""              //图片2
    var pic3 = ""              //图片3
    var deliverCompany = ""              //物流公司ID;//前端不显示
    var deliverCompanyName = ""              //物流公司名称
    var deliverNo = ""              //物流单号

    var partsList:[Parts] = []//配件列表
    
    //-- 下面为配件更换信息
    var orderPartsList:[OrderParts] = []      //工单配件更换列表

    
    var addressType = 1    //收货地址:1服务站;2用户家
    var addressTypeList:[AddressType] = []//收货地点与地区地址对应数据;在收货地址切换时,地区，地址，联系人信息进行同步切换;
    var partsBalance = ""         //可用配件额度
    
    var applyPartsMode = ""         //申请模式:1直接申请;2提交PC
    var waitApplyPartsList:[WaitApplyParts] = []        //待申请配件列表
    init(_ data:[String:Any] = [:]) {
        applyId = data.stringValue(forKey: "applyId")
        applyNo = data.stringValue(forKey: "applyNo")
        applyButton = data.stringValue(forKey: "applyButton")
        stat = data.stringValue(forKey: "stat")
        statName = data.stringValue(forKey: "statName")
        deliverProvince = data.stringValue(forKey: "deliverProvince")
        deliverCity = data.stringValue(forKey: "deliverCity")
        deliverCounty = data.stringValue(forKey: "deliverCounty")
        delieverTown = data.stringValue(forKey: "delieverTown")
        areaId = data.stringValue(forKey: "areaId")
        deliverAddress = data.stringValue(forKey: "deliverAddress")
        deliverMan = data.stringValue(forKey: "deliverMan")
        deliverMobile = data.stringValue(forKey: "deliverMobile")
        outType = data.stringValue(forKey: "outType")
        outTypeWarehouseList = data.arrayValue(forKey: "outTypeWarehouseList").compactMap({OutTypeWarehouse($0)})
        outWarehouseId = data.stringValue(forKey: "outWarehouseId")
        outWarehouseName = data.stringValue(forKey: "outWarehouseName")
        deliverType = data.stringValue(forKey: "deliverType")
        deliverTypeName = data.stringValue(forKey: "deliverTypeName")
        createByAndDate = data.stringValue(forKey: "createByAndDate")
        qtyAndAmount = data.stringValue(forKey: "qtyAndAmount")
        remark = data.stringValue(forKey: "remark")
        pic1 = kGetServerPicUrl(data.stringValue(forKey: "pic1")) 
        pic2 = kGetServerPicUrl(data.stringValue(forKey: "pic2"))
        pic3 = kGetServerPicUrl(data.stringValue(forKey: "pic3"))
        deliverCompany = data.stringValue(forKey: "deliverCompany")
        deliverCompanyName = data.stringValue(forKey: "deliverCompanyName")
        deliverNo = data.stringValue(forKey: "deliverNo")
        partsList = data.arrayValue(forKey: "partsList").compactMap({Parts($0)})
        orderPartsList = data.arrayValue(forKey: "orderPartsList").compactMap({OrderParts($0)})
        
        addressTypeList = data.arrayValue(forKey: "addressTypeList").compactMap({AddressType($0)})
        partsBalance = data.stringValue(forKey: "partsBalance")
        
        applyPartsMode = data.stringValue(forKey: "applyPartsMode")
        waitApplyPartsList = data.arrayValue(forKey: "waitApplyPartsList").compactMap({WaitApplyParts($0)})
    }
    
    func jsonValue() -> [String:Any] {
        var par:[String:Any] = [:]
        par["applyId"] = applyId
        par["deliverProvince"] = deliverProvince
        par["deliverCity"] = deliverCity
        par["deliverCounty"] = deliverCounty
        par["delieverTown"] = delieverTown
        par["areaId"] = areaId
        par["deliverAddress"] = deliverAddress
        par["deliverMan"] = deliverMan
        par["deliverMobile"] = deliverMobile
        par["outType"] = outType
        par["outWarehouseId"] = outWarehouseId
        par["remark"] = remark
        par["pic1"] = kGetPicUrl(pic1)
        par["pic2"] = kGetPicUrl(pic2)
        par["pic3"] = kGetPicUrl(pic3)
        par["partsList"] = partsList.compactMap({$0.jsonValue()})

        return par
    }

    
    //MARK: 发出类型与发出仓库对应List;在上面的发出类型切换时,发出仓库的可选值也需要切换为对应的仓库列表
    class OutTypeWarehouse: NSObject {
        var outType = "1"          //发出类型:1总部;2区域
        var warehouseList:[Warehouse] = []//发出类型对应的仓库列表
        
        init(_ data:[String:Any] = [:]) {
            outType = data.stringValue(forKey: "outType")
            warehouseList = data.arrayValue(forKey: "warehouseList").compactMap({Warehouse($0)})
        }
        
//        func jsonValue() -> [String:Any] {
//            var par:[String:Any] = [:]
//            return par
//        }
        
        struct Warehouse {
            var warehouseId = ""       //仓库ID
            var warehouseName = ""       //仓库名称
            
            init(_ data:[String:Any] = [:]) {
                warehouseId = data.stringValue(forKey: "warehouseId")
                warehouseName = data.stringValue(forKey: "warehouseName")
            }
            
//            func jsonValue() -> [String:Any] {
//                var par:[String:Any] = [:]
//                return par
//            }
        }
    }
    
    //MARK: 配件列表
    struct Parts {
        var lineId = ""       //明细ID);
        var partsId = ""       //配件ID);
        var pic = ""       //图片,后台返回空值时,前端使用默认图片显示);
        var partsName = ""       //配件名称);
        var partsCode = ""       //配件编码);
        var sitePrice = ""       //价格);//前端不显示
        var applyQty = "1"       //申请数量);
        var applyAmount = ""       //申请金额);
        var checkQty = ""       //审核数量);
        var checkAmount = ""       //审核金额);
        var outQty = ""       //出库数量);
        var outAmount = ""       //出库金额);
        var getQty = ""       //收货数量);
        var getAmount = ""       //收货金额);
        
        var selected = false
        
        
        var userPrice = ""
//        var num = "1" //编辑的数量
        var maxQty = "0"
        var invQty = "0"
        var invQtyString = ""
        var myselfQty = ""
        var partsPic = ""
        init(_ data:[String:Any] = [:]) {
            lineId = data.stringValue(forKey: "lineId")
            partsId = data.stringValue(forKey: "partsId")
            partsName = data.stringValue(forKey: "partsName")
            partsCode = data.stringValue(forKey: "partsCode")
            sitePrice = data.stringValue(forKey: "sitePrice")
            applyQty = data.stringValue(forKey: "applyQty")
            applyAmount = data.stringValue(forKey: "applyAmount")
            checkQty = data.stringValue(forKey: "checkQty")
            checkAmount = data.stringValue(forKey: "checkAmount")
            outQty = data.stringValue(forKey: "outQty")
            outAmount = data.stringValue(forKey: "outAmount")
            getQty = data.stringValue(forKey: "getQty")
            getAmount = data.stringValue(forKey: "getAmount")
            pic = kGetServerPicUrl(data.stringValue(forKey: "pic"))
        }
        
        init(josn dic:[String:Any] = [:]) {
            invQty = dic.stringValue(forKey: "invQty")
            invQtyString = dic.stringValue(forKey: "invQtyString")
            maxQty = dic.stringForKey("maxQty")
            myselfQty = dic.stringValue(forKey: "myselfQty")
            partsCode = dic.stringValue(forKey: "partsCode")
            partsId = dic.stringValue(forKey: "partsId")
            partsName = dic.stringValue(forKey: "partsName")
            partsPic = kGetServerPicUrl(dic.stringValue(forKey: "partsPic"))
            userPrice = dic.stringForKey("userPrice")
            sitePrice = dic.stringForKey("userPrice")
            let qty = dic.stringValue(forKey: "applyQty")
            applyQty = qty.isEmpty ? "1" : qty
        }
        
        func jsonValue() -> [String:Any] {
            var par:[String:Any] = [:]
            par["lineId"] = lineId
            par["partsId"] = partsId
            par["partsName"] = partsName
            par["partsCode"] = partsCode
            par["sitePrice"] = sitePrice
            par["applyQty"] = applyQty
            return par
        }
    }
    
    //MARK: 配件更换信息
    struct OrderParts {
        var orderPartsId = ""            //工单配件ID
        var partsId = ""            //配件ID
        var pic = ""            //图片,后台返回空值时,前端使用默认图片显示
        var partsName = ""            //配件名称
        var partsCode = ""            //配件编码
        var partsStat = ""            //状态
        var partsStatName = ""            //状态名称
        var qty = ""            //数量
        var sitePrice = ""            //价格
        
        init(_ data:[String:Any] = [:]) {
            orderPartsId = data.stringValue(forKey: "orderPartsId")
            partsId = data.stringValue(forKey: "partsId")
            pic = kGetServerPicUrl(data.stringValue(forKey: "pic"))
            partsName = data.stringValue(forKey: "partsName")
            partsCode = data.stringValue(forKey: "partsCode")
            partsStat = data.stringValue(forKey: "partsStat")
            partsStatName = data.stringValue(forKey: "partsStatName")
            qty = data.stringValue(forKey: "qty")
            sitePrice = data.stringValue(forKey: "sitePrice")
        }
        
//        func jsonValue() -> [String:Any] {
//            var par:[String:Any] = [:]
//            return par
//        }
    }
    
    struct AddressType {
        var addressType = 1         //收货地址:1服务站;2用户家
        var addressList:[Address] = []          //收货地点(暂时数量都为1,以后可能会有多个可选地址的场景)
        
        init(_ data:[String:Any] = [:]) {
            addressType = data.intValue(forKey: "addressType")
            addressList = data.arrayValue(forKey: "addressList").compactMap({Address($0)})
        }
        
        struct Address {
            var deliverProvince = ""         //收货信息:省
            var deliverCity = ""         //收货信息:市
            var deliverCounty = ""         //收货信息:区
            var delieverTown = ""         //收货信息:镇
            var areaId = ""         //地区ID);//前端不显示
            var deliverAddress = ""         //收货详细地址
            var deliverMan = ""         //收货人
            var deliverMobile = ""         //联系电话
            
            init(_ data:[String:Any] = [:]) {
                deliverProvince = data.stringValue(forKey: "deliverProvince")
                deliverCity = data.stringValue(forKey: "deliverCity")
                deliverCounty = data.stringValue(forKey: "deliverCounty")
                delieverTown = data.stringValue(forKey: "delieverTown")
                areaId = data.stringValue(forKey: "areaId")
                deliverAddress = data.stringValue(forKey: "deliverAddress")
                deliverMan = data.stringValue(forKey: "deliverMan")
                deliverMobile = data.stringValue(forKey: "deliverMobile")
            }
        }
    }
    
    struct WaitApplyParts {
        var lineId = ""            //待申请配件明细ID
        var partsId = ""            //配件ID
        var pic = ""            //图片,后台返回空值时,前端使用默认图片显示
        var partsName = ""            //配件名称
        var partsCode = ""            //配件编码
        var waitQty = ""          //待申请数量);
        var applyQty = ""         //已申请数量);

        var qty = "1"
        var userPrice = "0"
        init(_ data:[String:Any] = [:]) {
            partsId = data.stringValue(forKey: "partsId")
            pic = kGetServerPicUrl(data.stringValue(forKey: "pic"))
            partsName = data.stringValue(forKey: "partsName")
            partsCode = data.stringValue(forKey: "partsCode")
            lineId = data.stringValue(forKey: "lineId")
            waitQty = data.stringValue(forKey: "waitQty")
            applyQty = data.stringValue(forKey: "applyQty")
            
            qty = waitQty.isEmpty ? "1" : waitQty
            
            let price = data.stringValue(forKey: "userPrice")
            userPrice = price.isEmpty ? "0" : price
        }
        
        func jsonValue() -> [String:Any] {
            var par:[String:Any] = [:]
            par["lineId"] = lineId
            par["partsId"] = partsId
            par["waitQty"] = qty
            return par
        }
    }
}
