//
//  M_OrderServiceSupport.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/11.
//

import Foundation

class M_OrderServiceSupport: NSObject {
    var yingXianJianYi = ""            //营销建议富文本
    var fuWuJianYi = ""            //服务建议富文本
    var knowledgeList:[Knowledge] = []//知识库列表(不分页,最多显示5条)
    var manList:[Man] = []//支持人员列表(不分页,最多显示5条)
    
    init(_ data:[String:Any] = [:]) {
        yingXianJianYi = data.stringValue(forKey: "yingXianJianYi")
        fuWuJianYi = data.stringValue(forKey: "fuWuJianYi")
        knowledgeList = data.arrayValue(forKey: "knowledgeList").compactMap({Knowledge($0)})
        manList = data.arrayValue(forKey: "manList").compactMap({Man($0)})
    }
    
    struct Knowledge {
        var knowledgeId = ""            // 知识库ID
        var title = ""            //标题
        
        init(_ data:[String:Any] = [:]) {
            knowledgeId = data.stringValue(forKey: "knowledgeId")
            title = data.stringValue(forKey: "title")
        }
    }
    
    struct Man {
        var pic = ""            //头像,如果为null时前端使用默认图片
        var name = ""            //姓名
        var mobile = ""            //电话
        var lable = ""             //标签
        
        init(_ data:[String:Any] = [:]) {
            pic = kGetServerPicUrl(data.stringValue(forKey: "pic"))
            name = data.stringValue(forKey: "name")
            mobile = data.stringValue(forKey: "mobile")
            lable = data.stringValue(forKey: "lable")
        }
    }
}
