//
//  OrderAssignUserCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/31.
//

import UIKit

class OrderAssignUserCell: UITableViewCell {
    @IBOutlet weak var imgV_head: UIImageView!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_phone: UILabel!
    @IBOutlet weak var lab_orderCount: UILabel!
    @IBOutlet weak var lab_address: UILabel!
    @IBOutlet weak var btn_select: UIButton!
    @IBOutlet weak var lab_txt: UILabel!
    @IBOutlet weak var width_txt: NSLayoutConstraint!
    
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        lab_txt.text = "工单容量".languageString()
        width_txt.constant = "工单容量".languageString().getLabelWidth(h: 20, f: UIFont.PingFangMedium(size: 10)) + 8
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        callback?(sender.tag)
    }
    
    func localString(_ addressStr:String,_ distanceStr:String) -> NSMutableAttributedString  {
        let addressAtt = NSMutableAttributedString(string: addressStr)
//        if !distanceStr.isEmpty {
        let distanceAtt = NSAttributedString(string: (" | \("距离用户家".languageString())" + (distanceStr.isEmpty ? " " : distanceStr) + (["km","KM"].contains(distanceStr) ? "" : "km")), attributes: [NSAttributedString.Key.foregroundColor : Config.color.hex("9"),
                                                                                                    NSAttributedString.Key.font : Config.font.fontRegular(12)])
            addressAtt.append(distanceAtt)
//        }
        return addressAtt
    }
}
extension OrderAssignUserCell: TCCell_RowCellUpdateProtocol {
    
    typealias DataSource = Any
    
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        if let data = data as? M_OrderAssignUser {
            imgV_head.sd_setImage(with: URL(string: data.pic), placeholderImage: UIImage(named: "order_assign_profile"))
            lab_name.cd.text(data.engineerName.isEmpty ? data.siteName : data.engineerName)
            lab_phone.cd.text(data.engineerMobile.isEmpty ? data.mobile : data.engineerMobile)
            lab_orderCount.cd.text("\(data.unFinishOrderQty)\(isEnglish() ? "" : "单")")
            btn_select.cd.image(data.isSelect ? UIImage(named: "icon_circle_sel") : UIImage(named: "icon_circle"))
            lab_address.cd.text(localString(data.address, data.mapDistance))
        }
    }
    
    func row_update(config data: ConfigModel) {
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
