//
//  OrderAssistPersonSelectedCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/8.
//

import UIKit

class OrderAssistPersonSelectedCell: UITableViewCell {
    @IBOutlet weak var img_head: UIImageView!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_phone: UILabel!
    @IBOutlet weak var btn_del: UIButton!
    
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func removeItem(_ sender: UIButton) {
        callback?(sender.tag)
    }
}
extension OrderAssistPersonSelectedCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String,String,String)
    typealias ConfigModel = (Int)
    
    func row_update(dataSource data: DataSource) {
        img_head.sd_setImage(with: URL(string: data.0), placeholderImage: UIImage(named: "pic_profile"))
        lab_name.cd.text(data.1)
        lab_phone.cd.text(data.2)
    }
    
    func row_update(config data: ConfigModel) {
        btn_del.cd.tag(data)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
