//
//  OrderBookUserInfoCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/4.
//

import UIKit

class OrderBookUserInfoCell: UITableViewCell {
    @IBOutlet weak var img_head: UIImageView!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_phone: UILabel!
    @IBOutlet weak var lab_time: UILabel!
    
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func callPhone(_ sender: UIButton) {
        callback?(sender.tag)
    }
}
extension OrderBookUserInfoCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String, String, String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        img_head.sd_setImage(with: URL(string: data.0), placeholderImage: UIImage(named: "pic_profile_man"))
        lab_name.cd.text(data.1)
        lab_phone.cd.text(data.2)
        lab_time.cd.text("\("期望上门时间".languageString())：\(data.3)")
    }
    
    func row_update(config data: ConfigModel) {
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
