//
//  OrderComplainProcessCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/12.
//

import UIKit

class OrderComplainProcessCell: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var imgV_process: UIImageView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lineView: UIView!
    @IBOutlet weak var lab_detail: UILabel!
    @IBOutlet weak var stack_btns: UIStackView!
    @IBOutlet weak var btn_img1: UIButton!
    @IBOutlet weak var btn_img2: UIButton!
    @IBOutlet weak var btn_img3: UIButton!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        btn_img1.cd.tag(0)
        btn_img2.cd.tag(1)
        btn_img3.cd.tag(2)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        callBack?(sender.tag)
    }
}
extension OrderComplainProcessCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = M_Process
    typealias ConfigModel = Int
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.content)
        lab_detail.cd.text("\(data.createTime) | \(data.poster)：\(data.executorName)")
        
        stack_btns.cd.isHidden(data.imgArr.isEmpty)
        btn_img1.cd.isHidden(data.imgArr.isEmpty)
        btn_img2.cd.isHidden(data.imgArr.count < 2)
        btn_img3.cd.isHidden(data.imgArr.count < 3)
        guard !data.imgArr.isEmpty else {
            return
        }
        btn_img1.cd.setBgImage(data.imgArr[0])
        guard data.imgArr.count > 1 else {
            return
        }
        btn_img2.cd.setBgImage(data.imgArr[1])
        guard data.imgArr.count > 2 else {
            return
        }
        btn_img3.cd.setBgImage(data.imgArr[2])
    }
    
    func row_update(config data: ConfigModel) {
        imgV_process.cd.image(data == 0 ? UIImage(named: "orderDetail_process_dot_now") : UIImage(named: "orderDetail_process_dot"))
        lineView.cd.background(data == 0 ? Config.color.hex("#478BFF") : Config.color.hex("#D4D5D5"))
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        self.callBack = block
    }
}
