//
//  OrderDetailActionCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/29.
//

import UIKit

class OrderDetailActionCell: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var cellCollectionView: UICollectionView!
    
    var leftLayout = OrderDetailInfoVc.UICollectionViewLeftFlowLayout()
    
    //  数据
    var actionsArr = [String]()
    // 更多操作回调
    var actionCallBack:((String)->())?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        cellCollectionView.register(UINib(nibName: "OrderDetailNoteLabelCell", bundle: nil), forCellWithReuseIdentifier: "OrderDetailNoteLabelCell")
        cellCollectionView.isScrollEnabled = false
        cellCollectionView.delegate = self
        cellCollectionView.dataSource = self
        cellCollectionView.backgroundColor = .white
        cellCollectionView.collectionViewLayout = leftLayout
//        bgView.makeRadius(value: 8, type: .allCorners)
//        bgView.layer.masksToBounds = true
    }
    
    func setupData(actions:[String]){
        actionsArr = actions
        cellCollectionView.reloadData()
        contentView.setNeedsLayout()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    override func systemLayoutSizeFitting(_ targetSize: CGSize, withHorizontalFittingPriority horizontalFittingPriority: UILayoutPriority, verticalFittingPriority: UILayoutPriority) -> CGSize {
        bgView.frame = CGRect(x: 12, y: 0, width: targetSize.width-24, height: 44)
        bgView.layoutIfNeeded()
        
        cellCollectionView.frame = CGRect(x: 12, y: 12, width: targetSize.width-48, height: 44)
        cellCollectionView.layoutIfNeeded()

        let tagsCellHeight = cellCollectionView.collectionViewLayout.collectionViewContentSize.height
        return CGSize(width: targetSize.width, height: tagsCellHeight + 28)
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.makeRadius(value: 8, type: [.bottomLeft, .bottomRight])
    }
}

extension OrderDetailActionCell: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 1
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return actionsArr.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "OrderDetailNoteLabelCell", for: indexPath) as! OrderDetailNoteLabelCell
        cell.infoLabel.isHidden = false
        cell.infoLabel.numberOfLines = 1
        cell.infoLabel.text = actionsArr[indexPath.row]
        cell.infoLabel.backgroundColor = Config.color.hex("#FBFCFE")
        cell.infoLabel.textColor = Config.color.hex("#2D3132")
        cell.infoLabel.textAlignment = .center
        cell.bgView.layer.cornerRadius = 14
        cell.bgView.layer.borderWidth = 1
        cell.bgView.layer.borderColor = Config.color.hex("#D4D5D5").cgColor
//        cell.bgView.ts_setBorder(withCornerRadius: 14, borderWidth: 1, borderColor: kHexRGB(0xD4D5D5), type: .allCorners)
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let showInfo = actionsArr[indexPath.row]
        let tagWidth = showInfo.getLabelWidth(h: 18, f: Config.font.fontRegular(12))
        return CGSize(width: tagWidth + 24, height: 28)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
        return 12
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
        return 7
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        actionCallBack?(actionsArr[indexPath.row])
    }
    
}

extension OrderDetailActionCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = [String]
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        actionsArr = data
        cellCollectionView.reloadData()
        contentView.setNeedsLayout()
    }
    
    func row_update(config data: ConfigModel) {
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        actionCallBack = block
    }
}
