//
//  OrderDetailInfoCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/28.
//

import UIKit

class OrderDetailInfoCell: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_detail: UILabel!
    @IBOutlet weak var width_title: NSLayoutConstraint!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        bgView.cd.background(.white)
        self.contentView.cd.background(.clear)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
extension OrderDetailInfoCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
            .isHidden(data.0.isEmpty)
        lab_detail.cd.text(data.1)
            .isHidden(data.1.isEmpty)
        width_title.constant = data.0.getLabelWidth(h: 20, f: lab_title.font) + 2
    }
    
    func row_update(config data: ConfigModel) {
        if let data = data as? (UIColor, UIColor) {
            bgView.cd.background(data.0)
            self.contentView.cd.background(data.1)
        }else{
            bgView.cd.background(.white)
            self.contentView.cd.background(.clear)
        }
            
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        
    }
}
