//
//  OrderDetailPruductCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/28.
//

import UIKit

class OrderDetailPruductCell: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_qty: UILabel!
    @IBOutlet weak var bottomLine: UIView!
    
    var corner:(CGFloat, UIRectCorner) = (0,[])
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.cd.rounded(corner.1, CGSize(width: corner.0, height: corner.0))
//            .border(0.5, color: Config.color.hex("#FFE6E6"))
    }
}
extension OrderDetailPruductCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String)
    typealias ConfigModel = (CGFloat, UIRectCorner)
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
            .isHidden(data.0.isEmpty)
        lab_qty.cd.text(data.1)
            .isHidden(data.1.isEmpty)
    }
    
    func row_update(config data: ConfigModel) {
        corner = data
        bgView.makeRadius(value: corner.0, type: corner.1)
        bottomLine.isHidden = !corner.1.isEmpty
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        
    }
}
