//
//  OrderDetailServiceProcessCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/29.
//

import UIKit

class OrderDetailServiceProcessCell: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var imgV_process: UIImageView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_status: UILabel!
    @IBOutlet weak var lineView: UIView!
    @IBOutlet weak var lab_detail: UILabel!
    @IBOutlet weak var imgV_arrow: UIImageView!
    @IBOutlet weak var lab_time: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
extension OrderDetailServiceProcessCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String, Int, String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
            .isHidden(data.0.isEmpty)
        lab_detail.cd.text(data.1)
            .isHidden(data.1.isEmpty)
        imgV_process.cd.image(data.2 == 5 ? UIImage(named: "orderDetail_process_dot_now") : UIImage(named: "orderDetail_process_dot"))
        lineView.cd.background(data.2 == 5 ? Config.color.hex("#478BFF") : Config.color.hex("#D4D5D5"))
//        imgV_arrow.cd.isHidden(![2,5].contains(data.2))
        imgV_arrow.cd.isHidden(true)
        switch data.2 {
        case 1:
            lab_status.cd.text("进行中".languageString())
        case 2:
            lab_status.cd.text("已暂存".languageString())
        case 5:
            lab_status.cd.text("已完成".languageString())
        case 9:
            lab_status.cd.text("已屏蔽".languageString())
        default:
            lab_status.cd.text("")
            break
        }
        
        lab_time.cd.text(data.3)
    }
    
    func row_update(config data: ConfigModel) {
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        
    }
}
