//
//  OrderDetailTitleCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/28.
//

import UIKit

class OrderDetailTitleCell: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var blueView: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_status: UILabel!
    @IBOutlet weak var width_blueV: NSLayoutConstraint!
    @IBOutlet weak var img_arrow: UIImageView!
    
    @IBOutlet weak var btn_select: UIButton!
    @IBOutlet weak var btn_copy: UIButton!
    var titleStr = ""
    var corner:(CGFloat, UIRectCorner) = (0,[])
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        btn_copy.cd.text("复制".languageString())
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.makeRadius(value: corner.0, type: corner.1)
        blueView.cd.gradient(layerAxial: [(Config.color.hex("#478BFF").cd_alpha(0), Float(0)), (Config.color.hex("#478BFF").cd_alpha(0.25), Float(1))], point: (CGPoint(x: 1.00, y: 0.50), CGPoint(x: 0.00, y: 0.50)))
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        callback?(sender.tag)
    }
    
    @IBAction func copyNum(_ sender: UIButton) {
        UIPasteboard.general.string = titleStr
        CD.visibleVC?.view.cd.hud(.succeed, title: "已复制".languageString(), model:CD_HUD.modelDefault)
    }
}
extension OrderDetailTitleCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        titleStr = data.0
        lab_title.cd.text(data.0)
            .isHidden(data.0.isEmpty)
        lab_status.cd.text(data.1)
            .isHidden(data.1.isEmpty)
    }
    
    func row_update(config data: ConfigModel) {
        if let data = data as? (CGFloat, UIRectCorner) {
            corner = data
            bgView.makeRadius(value: corner.0, type: corner.1)
            img_arrow.cd.isHidden(true)
        }
        
        if let data = data as? ((CGFloat, UIRectCorner), UIColor, UIColor) {
            corner = data.0
            bgView.makeRadius(value: corner.0, type: corner.1)
            bgView.cd.background(data.1)
            self.contentView.cd.background(data.2)
            width_blueV.constant = 54
            img_arrow.cd.isHidden(true)
        }
        
        if let data = data as? ((CGFloat, UIRectCorner), Bool) {
            corner = data.0
            bgView.makeRadius(value: corner.0, type: corner.1)
            
            img_arrow.cd.isHidden(!data.1)
            lab_status.cd.text(Config.color.hex("#478BFF"))
                .background(.clear)
            btn_select.cd.isHidden(!data.1)
        }
        
        if let data = data as? ((CGFloat, UIRectCorner), Bool, Bool) {
            corner = data.0
            bgView.makeRadius(value: corner.0, type: corner.1)
            
            img_arrow.cd.isHidden(!data.1)
            lab_status.cd.text(Config.color.hex("#478BFF"))
                .background(.clear)
            btn_select.cd.isHidden(data.2)
        }
        
        if let data = data as? ((CGFloat, UIRectCorner), Bool, Bool, UIColor) {
            corner = data.0
            bgView.makeRadius(value: corner.0, type: corner.1)
            
            img_arrow.cd.isHidden(!data.1)
            lab_status.cd.text(data.3)
                .background(.clear)
            btn_select.cd.isHidden(data.2)
        }
        
        if let data = data as? (Bool, (CGFloat, UIRectCorner)) {
            btn_copy.isHidden = !data.0
            corner = data.1
            bgView.makeRadius(value: corner.0, type: corner.1)
            img_arrow.cd.isHidden(true)
        }
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
