//
//  OrderDetailUserInfoCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/28.
//

import UIKit

class OrderDetailUserInfoCell: UITableViewCell {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_address: UILabel!
    @IBOutlet weak var btn_address: UIButton!
    @IBOutlet weak var btn_phone: UIButton!
    @IBOutlet weak var imgV_warrantyType: UIImageView!
    @IBOutlet weak var imgV_serviceType: UIImageView!
    @IBOutlet weak var imgV_urgent: UIImageView!
    @IBOutlet weak var line: UIView!
    @IBOutlet weak var lab_warrantyType: UILabel!
    @IBOutlet weak var lab_serviceType: UILabel!
    
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        let imgName = isEnglish() ? "tag_urgent" : "list_jiaji"
        imgV_urgent.cd.image(UIImage(named: imgName))
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        switch sender {
        case btn_phone:
            callback?("phone")
            break
        case btn_address:
            callback?("address")
            break
        default:
            break
        }
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.cd
            .gradient(layerAxial: [(Config.color.hex("#ECF3FE"), Float(0)), (Config.color.hex("f"), Float(1))], point: (CGPoint(x: 0.50, y: 0.00), CGPoint(x: 0.50, y: 1)))
            .rounded([.topLeft, .topRight], CGSize(width: 8, height: 8))
//            .border(0.5, color: Config.color.hex("#FFE6E6"))
    }
    
    func localString(_ addressStr:String,_ distanceStr:String) -> NSMutableAttributedString  {
        let addressAtt = NSMutableAttributedString(string: addressStr)
        if !distanceStr.isEmpty {
            let distanceAtt = NSAttributedString(string: (" | " + distanceStr + (["km","KM"].contains(distanceStr) ? "" : "KM")), attributes: [NSAttributedString.Key.foregroundColor : Config.color.hex("9"),
                                                                                                    NSAttributedString.Key.font : Config.font.fontRegular(14)])
            addressAtt.append(distanceAtt)
        }
        return addressAtt
    }
}
extension OrderDetailUserInfoCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = Any
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        if let data = data as? M_OrderDetailInfo {
            lab_name.cd.text("\(data.userName)  \(data.userMobile)")
            lab_address.cd.text(localString(data.userAddress, data.distance))
            imgV_urgent.cd.isHidden(data.isUrgent == 0)
            lab_serviceType.cd.text(data.serviceTypeName.languageString())
            lab_warrantyType.cd.text(data.guaranteeTypeName.languageString())
        }
    }
    
    func row_update(config data: ConfigModel) {
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
