//
//  OrderHelperCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/8.
//

import UIKit

class OrderHelperCell: UITableViewCell {
    @IBOutlet weak var img_head: UIImageView!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_phone: UILabel!
    @IBOutlet weak var btn_select: UIButton!
    @IBOutlet weak var lab_orderCount: UILabel!
    @IBOutlet weak var lab_serviceArea: UILabel!
    @IBOutlet weak var lab_status: UILabel!
    @IBOutlet weak var lab_txt1: UILabel!
    @IBOutlet weak var lab_txt2: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        lab_txt1.text = "工单容量".languageString()
        lab_txt2.text = "服务大区".languageString()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
extension OrderHelperCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = Any
    typealias ConfigModel = (Int)
    
    func row_update(dataSource data: DataSource) {
        if let data = data as? M_OrderTransfer {
            img_head.sd_setImage(with: URL(string: data.pic), placeholderImage: UIImage(named: "pic_profile"))
            lab_name.cd.text(data.name)
            lab_phone.cd.text(data.mobile)
            lab_orderCount.cd.text(data.unFinishOrderQty)
            lab_serviceArea.cd.text(data.orgName)
            btn_select.cd.image(data.isSelect ? UIImage(named: "icon_circle_sel") : UIImage(named: "icon_circle"))
            switch data.usable {
            case "1":
                lab_status.cd.text("启用".languageString())
                    .background(Config.color.hex("0").cd_alpha(0.4))
                    .isHidden(false)
            case "0":
                lab_status.cd.text("禁用".languageString())
                    .background(Config.color.hex("f33232"))
                    .isHidden(false)
            default:
                lab_status.cd.isHidden(true)
            }
        }
    }
    
    func row_update(config data: ConfigModel) {
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
//        callback = block
    }
}
