//
//  OrderOperationLineCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/18.
//

import UIKit

class OrderOperationLineCell: UITableViewCell {
    @IBOutlet weak var view_bg: UIView!
    @IBOutlet weak var view_content: UIView!
    @IBOutlet weak var view_line: UIView!
    @IBOutlet weak var left1: NSLayoutConstraint!
    @IBOutlet weak var left2: NSLayoutConstraint!
    @IBOutlet weak var left3: NSLayoutConstraint!
    
    var corner:(CGFloat, UIRectCorner, Int) = (0, [], 0)
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        switch corner.2 {
        case 0:
            self.contentView.makeRadius(value: corner.0, type: corner.1)
            view_bg.makeRadius(value: 0, type: [])
            view_content.makeRadius(value: 0, type: [])
        case 1:
            self.contentView.makeRadius(value: 0, type: [])
            view_bg.makeRadius(value: corner.0, type: corner.1)
            view_content.makeRadius(value: 0, type: [])
        case 2:
            self.contentView.makeRadius(value: 0, type: [])
            view_bg.makeRadius(value: 0, type: [])
            view_content.makeRadius(value: corner.0, type: corner.1)
        default:
            self.contentView.makeRadius(value: 0, type: [])
            view_bg.makeRadius(value: 0, type: [])
            view_content.makeRadius(value: 0, type: [])
        }
    }
}
extension OrderOperationLineCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (UIColor, UIColor, UIColor, UIColor)
    typealias ConfigModel = (CGFloat,CGFloat,CGFloat,(CGFloat, UIRectCorner, Int))
    
    func row_update(dataSource data: DataSource) {
        self.contentView.cd.background(data.0)
        view_bg.cd.background(data.1)
        view_content.cd.background(data.2)
        view_line.cd.background(data.3)
    }
    
    func row_update(config data: ConfigModel) {
        left1.constant = data.0
        left2.constant = data.1
        left3.constant = data.2
        corner = data.3
        switch corner.2 {
        case 0:
            self.contentView.makeRadius(value: corner.0, type: corner.1)
            view_bg.makeRadius(value: 0, type: [])
            view_content.makeRadius(value: 0, type: [])
        case 1:
            self.contentView.makeRadius(value: 0, type: [])
            view_bg.makeRadius(value: corner.0, type: corner.1)
            view_content.makeRadius(value: 0, type: [])
        case 2:
            self.contentView.makeRadius(value: 0, type: [])
            view_bg.makeRadius(value: 0, type: [])
            view_content.makeRadius(value: corner.0, type: corner.1)
        default:
            self.contentView.makeRadius(value: 0, type: [])
            view_bg.makeRadius(value: 0, type: [])
            view_content.makeRadius(value: 0, type: [])
        }
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        
    }
}
