//
//  OrderOperationRemarkVCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/30.
//

import UIKit

class OrderOperationRemarkVCell: UITableViewCell, UITextViewDelegate {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var tv_remark: UITextView!
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var line: UIView!
    
    var corner:(CGFloat, UIRectCorner) = (0,[])
    
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        tv_remark.delegate = self
        tv_remark.tintColor = Config.color.hex("#478BFF")
        tv_remark.placeholder = "请填写备注".languageString()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.cd.rounded(corner.1, CGSize(width: corner.0, height: corner.0))
    }
    
    func textViewDidEndEditing(_ textView: UITextView) {
        callback?(textView.text)
    }
    
}
extension OrderOperationRemarkVCell: TCCell_RowCellUpdateProtocol {
    
    typealias DataSource = (String, String)
    
    typealias ConfigModel = ((CGFloat, UIRectCorner), Bool)
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
        tv_remark.cd.text(data.1)
    }
    
    func row_update(config data: ConfigModel) {
        corner = data.0
        line.cd.isHidden(data.1)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
