//
//  OrderOperationSelectCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/30.
//

import UIKit

class OrderOperationSelectCell: UITableViewCell {

    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var infoLabel: UILabel!
    @IBOutlet weak var nextView: UIImageView!
    @IBOutlet weak var line: UIView!
    @IBOutlet weak var bgView: UIView!
    
    var corner:(CGFloat, UIRectCorner) = (0,[])
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.cd.rounded(corner.1, CGSize(width: corner.0, height: corner.0))
    }
}

extension OrderOperationSelectCell: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String, String)

    typealias ConfigModel = (Bool, Bool, (CGFloat, UIRectCorner))

    func row_update(dataSource data: DataSource) {
        titleLabel.text = data.0
        if data.1.isEmpty {
            infoLabel.text = "请选择".languageString()
            infoLabel.textColor = Config.color.hex("#9EA8B9")
        }else{
            if data.1 == "nil" {
                infoLabel.text = ""
            }else{
                infoLabel.text = data.1
                infoLabel.textColor = Config.color.hex("3")
            }
        }
    }

    func row_update(config data: ConfigModel) {
        line.isHidden = data.0
        nextView.isHidden = data.1
        corner = data.2
        bgView.cd.rounded(corner.1, CGSize(width: corner.0, height: corner.0))
    }

}
