//
//  OrderOperationSwitchCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/1.
//

import UIKit

class OrderOperationSwitchCell: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var img_select1: UIImageView!
    @IBOutlet weak var lab_select1: UILabel!
    @IBOutlet weak var btn_select1: UIButton!
    @IBOutlet weak var img_select2: UIImageView!
    @IBOutlet weak var lab_select2: UILabel!
    @IBOutlet weak var btn_select2: UIButton!
    @IBOutlet weak var line: UIView!
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var stack_switch: UIStackView!
    @IBOutlet weak var img_select3: UIImageView!
    @IBOutlet weak var lab_select3: UILabel!
    @IBOutlet weak var btn_select3: UIButton!
    @IBOutlet weak var view_select3: UIView!
    
    @IBOutlet weak var width_title: NSLayoutConstraint!
    
    var callback: TCRowCallBack?
    var corner:(CGFloat, (UIRectCorner)) = (0,[])
    override func awakeFromNib() {
        super.awakeFromNib()
        btn_select1.cd.tag(1)
        btn_select2.cd.tag(2)
        btn_select3.cd.tag(3)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func selectButton(_ sender: UIButton) {
        callback?(sender.tag)
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.makeRadius(value: corner.0, type: corner.1)
    }
}
extension OrderOperationSwitchCell: TCCell_RowCellUpdateProtocol {
    
    typealias DataSource = (String, String, String, String, Int)
    
    typealias ConfigModel = (Bool, (CGFloat, (UIRectCorner)))
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
        lab_select1.cd.text(data.1)
        lab_select2.cd.text(data.2)
        lab_select3.cd.text(data.3)
        img_select1.cd.image(data.4 == 1 ? UIImage(named: "icon_circle_sel") : UIImage(named: "icon_circle"))
        img_select2.cd.image(data.4 == 2 ? UIImage(named: "icon_circle_sel") : UIImage(named: "icon_circle"))
        img_select3.cd.image(data.4 == 3 ? UIImage(named: "icon_circle_sel") : UIImage(named: "icon_circle"))
        
        if [.iPhone4, .iPhoneSE].contains(CD.Device.mode) {
            lab_select1.cd.text(Config.font.fontRegular(13))
            lab_select2.cd.text(Config.font.fontRegular(13))
            lab_select3.cd.text(Config.font.fontRegular(13))
            stack_switch.spacing = data.3.isEmpty ? 20 : 5
        }else{
            stack_switch.spacing = 20
        }
        view_select3.cd.isHidden(data.3.isEmpty)
        
        width_title.constant = data.0.getLabelWidth(h: 20, f: lab_title.font)
    }
    
    func row_update(config data: ConfigModel) {
        line.cd.isHidden(data.0)
        corner = data.1
        bgView.makeRadius(value: data.1.0, type: data.1.1)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
