//
//  OrderOperationTextFieldCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/1.
//

import UIKit

class OrderOperationTextFieldCell: UITableViewCell, UITextFieldDelegate {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var tf_text: UITextField!
    @IBOutlet weak var btn: UIButton!
    @IBOutlet weak var line: UIView!
    @IBOutlet weak var width_title: NSLayoutConstraint!
    
    @IBOutlet weak var view_scan: UIView!
    @IBOutlet weak var btn_scan: UIButton!
    
    var corner:(CACornerMask, CGFloat) = ([],0)
    var callback:TCRowCallBack?
    
    weak var model: M_VerifyCode?
    var ob:NSObjectProtocol?
    
    var titleStr = ""
    override func awakeFromNib() {
        super.awakeFromNib()
        tf_text.delegate = self
        tf_text.placeholder = "请输入".languageString()
        btn.cd.text("获取验证码".languageString())
        btn.titleLabel?.adjustsFontSizeToFitWidth = true
        ob = CD.notice.addObserver(forName: NSNotification.Name(rawValue: M_VerifyCode.verifyCodeSendId), object: nil, queue: nil, using: { [weak self](n) in
            self?.makeNotification(n)
        })
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func EditingDidEnd(_ sender: UITextField) {
        
        callback?(sender.text!)
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        switch sender {
        case btn_scan:
            callback?(-999)
        default:
            callback?(-60)
        }
    }
    
    func makeNotification(_ n:Notification) {
        guard let m = n.userInfo?[M_VerifyCode.verifyCodeSendId] as? CD_Timer.Model else {
            return
        }
        if m.remainTime <= 0 {
            self.btn.cd.text("获取验证码".languageString())
                .background(Config.color.hex("1777FF"))
                .isUser(true)
            model?.isCodeEnabled = true
        }else{
            self.btn.cd.text("\(m.second)s\("重新获取".languageString())")
                .background(Config.color.hex("DE"))
                .isUser(false)
            model?.isCodeEnabled = false
        }
    }
}
extension OrderOperationTextFieldCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = Any
    typealias ConfigModel = (Bool, Bool, (CACornerMask, CGFloat), Bool)
    
    func row_update(dataSource data: DataSource) {
        if let data = data as? (String, String, UIKeyboardType) {
            titleStr = data.0
            lab_title.cd.text(data.0)
            tf_text.cd.text(data.1)
                .text(Config.font.fontRegular(14))
                .keyboardType(data.2)
                .tint(Config.color.hex("#478BFF"))
            if isEnglish() {
                width_title.constant = titleStr.getLabelWidth(h: 20, f: lab_title.font) + 2
            }
        }else if let data = data as? (String,M_VerifyCode, UIKeyboardType) {
            titleStr = data.0
            lab_title.cd.text(data.0)
            model = data.1
            tf_text.cd.text(data.1.verifyCode)
                .keyboardType(data.2)
                .tint(Config.color.hex("#478BFF"))
            data.1.blockCodeEnabled = { [unowned self] b in
                self.btn.cd
                    .background(b ? Config.color.hex("#478BFF") : Config.color.hex("DE"))
                    .isUser(b)
            }
            
            self.btn.cd
                .background(data.1.isCodeEnabled ? Config.color.hex("#478BFF") : Config.color.hex("DE"))
                .isUser(data.1.isCodeEnabled)
            if isEnglish() {
                width_title.constant = titleStr.getLabelWidth(h: 20, f: lab_title.font) + 2
            }
        }else if let data = data as? (String, String, UIKeyboardType, Bool) {
            titleStr = data.0
            lab_title.cd.text(data.0)
            width_title.constant = titleStr.getLabelWidth(h: 20, f: lab_title.font) + 2
            tf_text.cd.text(data.1)
                .text(Config.font.fontRegular(14))
                .keyboardType(data.2)
                .tint(Config.color.hex("#478BFF"))
            view_scan.cd.isHidden(!data.3)
            btn.cd.isHidden(true)
        }
    }
    
    func row_update(config data: (Bool, Bool, (CACornerMask, CGFloat), Bool)) {
        tf_text.cd.isUser(data.3)
        btn.cd.isHidden(data.0)
        line.cd.isHidden(data.1)
        bgView.makeLayerRadius(value: data.2.1, type: data.2.0)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}

class M_VerifyCode {
    var verifyCode = ""
    static let verifyCodeSendId = "LegalRegisterCode"
    var blockCodeEnabled:((Bool) -> (Void))?
    var isCodeEnabled:Bool = false {
        didSet{
            guard isCodeEnabled != oldValue else {
                return
            }
            blockCodeEnabled?(isCodeEnabled)
        }
    }
}
