//
//  OrderOperationTextViewCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/4.
//

import UIKit

class OrderOperationTextViewCell: UITableViewCell, UITextViewDelegate {

    @IBOutlet weak var textV: UITextView!
    
    var maxCount = 0
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        textV.delegate = self
        textV.tintColor = Config.color.hex("#478BFF")
        textV.placeholder = "请输入".languageString()
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    func textViewDidEndEditing(_ textView: UITextView) {
        callback?(textView.text!)
    }
    
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        guard text != "" else {
            return true
        }
        if maxCount > 0 {
            if textView.text.count < maxCount {
                return true
            }else{
                return false
            }
        }
        return true
    }
}
extension OrderOperationTextViewCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = String
    typealias ConfigModel = (String, Int)
    
    func row_update(dataSource data: DataSource) {
        textV.cd.text(data)
    }
    
    func row_update(config data: ConfigModel) {
        textV.placeholder = data.0
        maxCount = data.1
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
