//
//  OrderPartsApplyListItemAmountCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/18.
//

import UIKit

class OrderPartsApplyListItemAmountCell: UITableViewCell {
    @IBOutlet weak var lab_data1: UILabel!
    @IBOutlet weak var lab_data2: UILabel!
    @IBOutlet weak var lab_data3: UILabel!
    @IBOutlet weak var lab_data4: UILabel!
    @IBOutlet weak var lab_txt1: UILabel!
    @IBOutlet weak var lab_txt2: UILabel!
    @IBOutlet weak var lab_txt3: UILabel!
    @IBOutlet weak var lab_txt4: UILabel!
    @IBOutlet weak var stack_first: UIStackView!
    @IBOutlet weak var stack_second: UIStackView!
    
    @IBOutlet weak var view_5: UIView!
    @IBOutlet weak var lab_txt5: UILabel!
    @IBOutlet weak var lab_data5: UILabel!
    
    @IBOutlet weak var view_content: UIView!
    var unit = ""
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
        unit = isEnglish() ? "" : "个"
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        view_content.cd.gradient(layerAxial: [(Config.color.hex("#ECF3FE"), Float(0)), (Config.color.hex("f"), Float(1))], point: (CGPoint(x: 0.50, y: 0.00), CGPoint(x: 0.50, y: 1.00)))
    }
}
extension OrderPartsApplyListItemAmountCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = Any
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        if let data = data as? M_OrderPartsInfo.Parts {
            lab_data1.cd.text("\(data.applyQty.isEmpty ? "0" : data.applyQty)\(unit)/￥\(data.applyAmount.isEmpty ? "0" : data.applyAmount)")
            lab_data2.cd.text("\(data.outQty.isEmpty ? "0" : data.outQty)\(unit)/￥\(data.outAmount.isEmpty ? "0" : data.outAmount)")
            lab_data3.cd.text("\(data.checkQty.isEmpty ? "0" : data.checkQty)\(unit)/￥\(data.checkAmount.isEmpty ? "0" : data.checkAmount)")
            lab_data4.cd.text("\(data.getQty.isEmpty ? "0" : data.getQty)\(unit)/￥\(data.getAmount.isEmpty ? "0" : data.getAmount)")
            lab_txt1.cd.text("申请数量/金额".languageString())
            lab_txt2.cd.text("出库数量/金额".languageString())
            lab_txt3.cd.text("审核数量/金额".languageString())
            lab_txt4.cd.text("收货数量/金额".languageString())
        }
        
        if let data = data as? M_PartsReturnDetail.Parts {
            stack_second.cd.isHidden(true)
            lab_data1.cd.text("\(data.returnQty.isEmpty ? "0" : data.returnQty)\(unit)/￥\(data.returnAmount.isEmpty ? "0" : data.returnAmount)")
            lab_data2.cd.text("\(data.inQty.isEmpty ? "0" : data.inQty)\(unit)/￥\(data.inAmount.isEmpty ? "0" : data.inAmount)")
            lab_txt1.cd.text("退回数量/金额".languageString())
            lab_txt2.cd.text("核销数量/金额".languageString())
        }
        
        if let data = data as? M_PartsBom.BOM {
            view_5.cd.isHidden(false)
            stack_second.cd.isHidden(true)
            lab_data1.cd.text("￥\(data.userPrice.isEmpty ? "0" : data.userPrice)")
            lab_data2.cd.text("\(data.maxQty.isEmpty ? "0" : data.maxQty)")
            lab_data5.cd.text("\(data.invQty.isEmpty ? "0" : data.invQty)")
            lab_txt1.cd.text("用户价".languageString())
            lab_txt2.cd.text("最大更换量".languageString())
            lab_txt5.cd.text("我的库存".languageString())
        }else{
            view_5.cd.isHidden(true)
        }
    }
    
    func row_update(config data: ConfigModel) {
    }
    
    func row_update(callBack block: TCRowCallBack?) {
    }
}
