//
//  OrderPartsReplaceListCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/15.
//

import UIKit

class OrderPartsReplaceListCell: UITableViewCell {
    @IBOutlet weak var imgV: UIImageView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_code: UILabel!
    @IBOutlet weak var lab_status: UILabel!
    @IBOutlet weak var lab_price: UILabel!
    @IBOutlet weak var lab_qty: UILabel!
    
    @IBOutlet weak var width_status: NSLayoutConstraint!
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
extension OrderPartsReplaceListCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = M_OrderPartsInfo.OrderParts
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        imgV.sd_setImage(with: URL(string: data.pic), placeholderImage: UIImage(named: "parts_default"))
        lab_title.cd.text(data.partsName)
        lab_code.cd.text("\("配件编码".languageString())：\(data.partsCode)")
        lab_status.cd.text(data.partsStatName)
        lab_price.cd.text("￥\(data.sitePrice)")
        lab_qty.cd.text("\(data.qty)\("件".languageString())")
        
        width_status.constant = data.partsStatName.getLabelWidth(h: 20, f: Config.font.fontRegular(14))
    }
    
    func row_update(config data: ConfigModel) {
    }
    
    func row_update(callBack block: TCRowCallBack?) {
    }
}
