//
//  OrderSupportTextCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/11.
//

import UIKit

class OrderSupportTextCell: UITableViewCell {

    @IBOutlet weak var lab_txt: UILabel!
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    func setText(_ strHtml:String) {
        lab_txt.text = strHtml
        lab_txt.numberOfLines = 0
        lab_txt.lineBreakMode = NSLineBreakMode.byClipping;//Tips:Supported six types.
        do{
            let srtData = strHtml.data(using: String.Encoding.unicode, allowLossyConversion: true)!
//            let strOptions = [NSAttributedString.DocumentAttributeKey.documentType: NSAttributedString.DocumentType.html]  //Tips:Supported four types.
            let strOptions:[NSAttributedString.DocumentReadingOptionKey : Any] = [NSAttributedString.DocumentReadingOptionKey.documentType: NSAttributedString.DocumentType.html]  //Tips:Supported four types.
            let attrStr = try NSAttributedString(data: srtData, options: strOptions, documentAttributes: nil)
            lab_txt.attributedText = attrStr
        }catch let error as NSError {
            print(error.localizedDescription)
        }
    }
}
extension OrderSupportTextCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = String
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        setText(data)
    }
    
    func row_update(config data: ConfigModel) {
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
    }
}
