//
//  OrderSupporterCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/11.
//

import UIKit

class OrderSupporterCell: UITableViewCell {
    @IBOutlet weak var img_head: UIImageView!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_phone: UILabel!
    @IBOutlet weak var lab_type: UILabel!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func clickbutton(_ sender: UIButton) {
        callBack?(sender.tag)
    }
}
extension OrderSupporterCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String,String,String,String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        img_head.sd_setImage(with: URL(string: data.0), placeholderImage: UIImage(named: "pic_profile"))
        lab_name.cd.text(data.1)
        lab_phone.cd.text(data.2)
        lab_type.cd.text(data.3)
            .isHidden(data.3.isEmpty)
    }
    
    func row_update(config data: ConfigModel) {
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        self.callBack = block
    }
}
