//
//  OrderWaitApplyPartsCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/13.
//

import UIKit

class OrderWaitApplyPartsCell: UITableViewCell, UITextFieldDelegate {
    @IBOutlet weak var imgV: UIImageView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_code: UILabel!
    @IBOutlet weak var btn_del: UIButton!
    @IBOutlet weak var lab_price: UILabel!
    @IBOutlet weak var tf_qty: UITextField!
    @IBOutlet weak var btn_sub: UIButton!
    @IBOutlet weak var btn_add: UIButton!
    
    var callBack: TCRowCallBack?
    
    var qty = 1
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        tf_qty.delegate = self
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        if sender.text!.intValue() < 1 {
            qty = 1
        }else{
            qty = sender.text!.intValue()
        }
        callBack?(tf_qty.text!)
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        switch sender {
        case btn_add:
            qty += 1
            tf_qty.text = "\(qty)"
            callBack?(tf_qty.text!)
        case btn_sub:
            if qty > 1 {
                qty -= 1
            }else{
                
            }
            tf_qty.text = "\(qty)"
            callBack?(tf_qty.text!)
        case btn_del:
            callBack?(-99)
        default:
            break
        }
        
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if string.isEmpty {
            return true
        }
        guard checkNum(string) else {
            return false
        }
        return true
    }
    
    func checkNum(_ str:String) -> Bool {
        let regex = "^[0-9]*$"
        let pred = NSPredicate(format: "SELF MATCHES %@", regex)
        if pred.evaluate(with: str) {
            return true
        }else{
            return false
        }
    }

}
extension OrderWaitApplyPartsCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = M_OrderPartsInfo.WaitApplyParts
    typealias ConfigModel = (Bool, Bool)
    
    func row_update(dataSource data: DataSource) {
        imgV.cd.background(Config.color.hex("f8"))
        imgV.sd_setImage(with: URL(string: data.pic), placeholderImage: UIImage(named: "parts_default"))
        lab_title.cd.text(data.partsName)
        lab_code.cd.text("\("配件编码".languageString())：\(data.partsCode)")
//        lab_price.cd.text("￥\(data.userPrice)")
        lab_price.cd.text("\("已申请数量".languageString())：\(data.applyQty)")
            .text(Config.font.fontRegular(12))
        
        qty = data.qty.intValue() < 1 ? 1 : data.qty.intValue()
        tf_qty.cd.text("\(qty)")
    }
    
    func row_update(config data: ConfigModel) {
        lab_price.cd.text(data.0 ? UIColor.clear : Config.color.hex("9"))
        btn_del.cd.isHidden(data.1)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        self.callBack = block
    }
}

