//
//  WorkbenchFirstGridCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/23.
//

import UIKit

class WorkbenchFirstGridCell: UITableViewCell {

    @IBOutlet weak var view0: UIView!
    @IBOutlet weak var imgV0: UIImageView!
    @IBOutlet weak var lab0: UILabel!
    @IBOutlet weak var btn0: UIButton!
    
    @IBOutlet weak var view1: UIView!
    @IBOutlet weak var imgV1: UIImageView!
    @IBOutlet weak var lab1: UILabel!
    @IBOutlet weak var btn1: UIButton!
    
    @IBOutlet weak var view2: UIView!
    @IBOutlet weak var imgV2: UIImageView!
    @IBOutlet weak var lab2: UILabel!
    @IBOutlet weak var btn2: UIButton!
    
    @IBOutlet weak var view3: UIView!
    @IBOutlet weak var imgV3: UIImageView!
    @IBOutlet weak var lab3: UILabel!
    @IBOutlet weak var btn3: UIButton!
    
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        callback?(sender.titleLabel?.text!)
    }
}
extension WorkbenchFirstGridCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = [(String, String)]
    typealias ConfigModel = Any
    
    func row_update(dataSource data: [(String, String)]) {
        view0.cd.isHidden(data.isEmpty)
        view1.cd.isHidden(data.count < 2)
        view2.cd.isHidden(data.count < 3)
        view3.cd.isHidden(data.count < 4)
        guard !data.isEmpty else {
            return
        }
        imgV0.cd.image(UIImage(named: data[0].0))
        lab0.cd.text(data[0].1)
        btn0.cd.text(data[0].1)
        guard data.count > 1 else {
            return
        }
        imgV1.cd.image(UIImage(named: data[1].0))
        lab1.cd.text(data[1].1)
        btn1.cd.text(data[1].1)
        guard data.count > 2 else {
            return
        }
        imgV2.cd.image(UIImage(named: data[2].0))
        lab2.cd.text(data[2].1)
        btn2.cd.text(data[2].1)
        guard data.count > 3 else {
            return
        }
        imgV3.cd.image(UIImage(named: data[3].0))
        lab3.cd.text(data[3].1)
        btn3.cd.text(data[3].1)
    }
    
    func row_update(config data: Any) {
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
