//
//  WorkbenchSecondGridCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/23.
//

import UIKit

class WorkbenchSecondGridCell: UITableViewCell {
    
    @IBOutlet weak var view0: UIView!
    @IBOutlet weak var lab_num0: UILabel!
    @IBOutlet weak var lab_title0: UILabel!
    @IBOutlet weak var btn_0: UIButton!
    
    @IBOutlet weak var view1: UIView!
    @IBOutlet weak var lab_num1: UILabel!
    @IBOutlet weak var lab_title1: UILabel!
    @IBOutlet weak var btn_1: UIButton!
    
    @IBOutlet weak var view2: UIView!
    @IBOutlet weak var lab_num2: UILabel!
    @IBOutlet weak var lab_title2: UILabel!
    @IBOutlet weak var btn_2: UIButton!
    
    @IBOutlet weak var view3: UIView!
    @IBOutlet weak var lab_num3: UILabel!
    @IBOutlet weak var lab_title3: UILabel!
    @IBOutlet weak var btn_3: UIButton!
    
    var callback: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    
    @IBAction func clickButton(_ sender: UIButton) {
        callback?(sender.titleLabel?.text!)
    }
}
extension WorkbenchSecondGridCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = [(String, String)]
    typealias ConfigModel = Any
    
    func row_update(dataSource data: [(String, String)]) {
        view0.cd.isHidden(data.isEmpty)
        view1.cd.isHidden(data.count < 2)
        view2.cd.isHidden(data.count < 3)
        view3.cd.isHidden(data.count < 4)
        guard !data.isEmpty else {
            return
        }
        lab_num0.cd.text(data[0].0)
        lab_title0.cd.text(data[0].1)
        btn_0.cd.text(data[0].1)
        guard data.count > 1 else {
            return
        }
        lab_num1.cd.text(data[1].0)
        lab_title1.cd.text(data[1].1)
        btn_1.cd.text(data[1].1)
        guard data.count > 2 else {
            return
        }
        lab_num2.cd.text(data[2].0)
        lab_title2.cd.text(data[2].1)
        btn_2.cd.text(data[2].1)
        guard data.count > 3 else {
            return
        }
        lab_num3.cd.text(data[3].0)
        lab_title3.cd.text(data[3].1)
        btn_3.cd.text(data[3].1)
    }
    
    func row_update(config data: Any) {
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callback = block
    }
}
