//
//  WorkbenchTitleCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/23.
//

import UIKit

class WorkbenchTitleCell: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var line: UIView!
    
    var corner:(CGFloat, CACornerMask) = (0,[])
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.makeLayerRadius(value: corner.0, type: corner.1)
    }
}
extension WorkbenchTitleCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String)
    typealias ConfigModel = ((CGFloat, CACornerMask), Bool, Bool)
    
    func row_update(config data: ConfigModel) {
        corner = data.0
        bgView.makeLayerRadius(value: data.0.0, type: data.0.1)
        line.cd.isHidden(data.1)
        bgView.cd.isHidden(data.2)
    }
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data)
    }
    
}
