//
//  ChangeVirtualNumberVc.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/13.
//

import UIKit

public struct R_ChangeVirtualNumber {
    static func router(_ userMobile:String, callBack:((String)->())?) {
        let vc = ChangeVirtualNumberVc.cd_storyboard("Order", from: "ChangeVirtualNumberVc") as! ChangeVirtualNumberVc
        vc.modalTransitionStyle = .crossDissolve
        vc.modalPresentationStyle = .custom
        vc.userMobile = userMobile
        vc.callBack = callBack
        CD.present(vc, animated: false)
    }
}

class ChangeVirtualNumberVc: UIViewController {
    @IBOutlet weak var lab_phone: UILabel!
    @IBOutlet weak var tf_realPhone: UITextField!
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_virtualTxt: UILabel!
    @IBOutlet weak var lab_realTxt: UILabel!
    @IBOutlet weak var btn_cancel: UIButton!
    @IBOutlet weak var btn_ok: UIButton!
    
    var userMobile = ""
    var callBack:((String)->())?
    override func viewDidLoad() {
        super.viewDidLoad()
        setTxt()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        lab_phone.cd.text(userMobile)
        
        bgView.transform = CGAffineTransform(scaleX: 0.01, y: 0.01)
        UIView.animate(withDuration: 0.3) {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.bgView.transform = CGAffineTransform(scaleX: 1, y: 1)
        }
    }
    
    func setTxt() {
        lab_title.text = "修改虚拟号".languageString()
        lab_virtualTxt.text = "虚拟号码：".languageString()
        lab_realTxt.text = "真实号码：".languageString()
        btn_cancel.cd.text("取消".languageString())
        btn_ok.cd.text("确定".languageString())
        tf_realPhone.placeholder = "请输入".languageString()
    }
    
    @IBAction func sure(_ sender: UIButton) {
        let txt = tf_realPhone.text!
        guard !txt.isEmpty else {
            hud_info("请输入真实手机号码".languageString())
            return
        }
        guard txt.isValidatePhoneNumber() else {
            hud_info("手机号码输入有误".languageString())
            return
        }
        callBack?(txt)
        dismissVc()
    }
    
    @IBAction func cancel(_ sender: UIButton) {
        dismissVc()
    }
    
    func dismissVc() {
        UIView.animate(withDuration: 0.3) {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.bgView.transform = CGAffineTransform(scaleX: 0.01, y: 0.01)
        } completion: { _ in
            self.dismiss(animated: false)
        }
    }
}
