//
//  OrderAskForHelpMainVc.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/8.
//

import UIKit
import JXSegmentedView

public struct R_OrderAskForHelp {
    static func router(_ orderid: String, callback: ((Bool)->Void)?) {
        let vc = OrderAskForHelpMainVc.cd_storyboard("Order", from: "OrderAskForHelpMainVc") as! OrderAskForHelpMainVc
        vc.orderId = orderid
        vc.callBack = callback
        CD.push(vc)
    }
}

class OrderAskForHelpMainVc: UIViewController, UITextFieldDelegate {

    @IBOutlet weak var stackBgV: UIStackView!
    @IBOutlet weak var headerV: UIView!
    @IBOutlet weak var curSubV: UIView!
    @IBOutlet weak var tf_search: UITextField!
    
    lazy var topBar: CD_TopBar = {
        return CD_TopBar()
    }()
    
    var state = 0
    
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    var segmentedtTitles:[String] = ["组队协助".languageString(), "完全转派".languageString()]
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        segmentedDa.titles = segmentedtTitles
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = Config.color.hex("6")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = Config.color.hex("3")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = Config.color.hex("#478BFF")
        indicator.indicatorWidth = 24
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    var orderId = ""
    
    var searchKey = ""
    
    var curViewC2 = OrderTransferVc()
    
    var callBack:((Bool)->Void)?
    override func viewDidLoad() {
        super.viewDidLoad()
        tf_search.delegate = self
        tf_search.returnKeyType = .search
        tf_search.placeholder = "请输入用户姓名".languageString()
        configUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.navigationController?.setNavigationBarHidden(true, animated: false)
    }
    
    func configUI() {
        self.cd.navigationBar(hidden: true)
        self.view.cd
            .add(topBar)
        topBar.delegate = self
        
        stackBgV.snp.makeConstraints { make in
            make.top.equalTo(topBar.snp_bottom)
        }
        
        segmentedView.defaultSelectedIndex = state
        segmentedDataSource.reloadData(selectedIndex: state)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        headerV.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
        
        addSubViewControlls()
        
        view.addSubview(self.listContainerView)
        segmentedView.listContainer = listContainerView
        curSubV.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        do {
            let curViewC1 = UIStoryboard(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "OrderTeamAssistanceVc") as! OrderTeamAssistanceVc
            curViewC1.vm.orderId = orderId
            cSubC.append(curViewC1)
        }
        
        do {
            curViewC2 = UIStoryboard(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "OrderTransferVc") as! OrderTransferVc
            curViewC2.vm.orderId = orderId
            curViewC2.vm.searchKey = searchKey
            curViewC2.vm.callBack = callBack
            cSubC.append(curViewC2)
        }
        
        subControllerList = cSubC
    }
    
    
    func setSelectIndex(_ idx:Int) {
        state = idx
        if !subControllerList.isEmpty {
            segmentedView.selectItemAt(index: state)
        }else{
            segmentedDataSource.reloadData(selectedIndex: state)
        }
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        searchKey = sender.text!
        curViewC2.vm.searchKey = searchKey
        if curViewC2.isViewLoaded {
            curViewC2.headerRefresh()
        }
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
}

extension OrderAskForHelpMainVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {

    }
}

extension OrderAskForHelpMainVc: CD_TopBarProtocol {
    func topBarCustom() {
        topBar.snp.makeConstraints { (make) in
            make.left.top.right.equalToSuperview()
        }
        topBar._style = "10"
        
        topBar.cd.background(.white)
        topBar._title = "请求协助".languageString()
        topBar.bar_navigation.item_centre._colorTitle = Config.color.hex("3")
        topBar.bar_navigation.item_centre.btn_1.titleLabel?.font = Config.font.fontMedium(18)
        topBar.bar_navigation.line.cd.isHidden(true)
    }
    
    func update(withTopBar item: CD_TopNavigationBar.Item) -> [CD_TopNavigationBarItem.Item.Style]? {
        switch item {
        case .leftItem1:
            let color:UIColor = Config.color.hex("6")
            let icon = CD_IconFont.tback_light(22)
            return [.title([(icon.text, icon.font, color, .normal), (icon.text, icon.font, Config.color.hex("6"), .highlighted), (icon.text, icon.font, Config.color.hex("6"), .selected)])]
        default:
            return nil
        }
    }
    
    func didSelect(withTopBar item: CD_TopNavigationBar.Item) {
        super_topBarClick(item)
        switch item {
        case .leftItem1:
            break
        default:
            break
        }
    }
}

