//
//  OrderComplainHandlingVc.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/11.
//

import UIKit
import JXSegmentedView

class OrderComplainHandlingVc: UIViewController {

    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var view_btns: UIView!
    
    @IBOutlet weak var btn_giveUp: UIButton!
    @IBOutlet weak var btn_submit: UIButton!
    
    var vm = OrderComplainHandlingVm()
    
    var siteComplainStat = 0
    
    var getStat:(()->Void)?
    override func viewDidLoad() {
        super.viewDidLoad()
        
        makeUI()
        vm.makeForms()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        getStat?()
        
        switch vm.viewType {
        case .complain:
            view_btns.cd.isHidden(![3,8,10].contains(siteComplainStat))
            btn_giveUp.cd.text("放弃申诉".languageString())
            btn_submit.cd.text("提交申诉".languageString())
        case .complainCheck:
            view_btns.cd.isHidden(siteComplainStat != 5)
            btn_giveUp.cd.isHidden(true)
            btn_submit.cd.text("确认审核".languageString())
        }
    }

    func makeUI() {
        vm.reloadData = {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.tableView.reloadData()
        }

        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.showsVerticalScrollIndicator = false
        tableView.showsHorizontalScrollIndicator = false
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        switch vm.viewType {
        case .complain:
            guard !vm.content.isEmpty else {
                hud_info("请填写申诉内容！".languageString())
                return
            }
            switch sender {
            case btn_giveUp:
                vm.requestComplain(1)
            case btn_submit:
                vm.requestComplain(2)
            default:
                break
            }
        case .complainCheck:
            if vm.checkType == 2 {
                guard !vm.content.isEmpty else {
                    hud_info("请填写工单申诉审核内容！".languageString())
                    return
                }
            }
            vm.requestComplainCheck()
        }
        
    }
}

extension OrderComplainHandlingVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}

extension OrderComplainHandlingVc:JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return self.view
    }
}
