//
//  OrderComplainMainVc.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/11.
//

import UIKit
import JXSegmentedView

enum ComplainType {
case complain         //工单申诉处理
case complainCheck    //工单申诉审核
}

public struct R_OrderComplainMain {
    static func router(_ orderid: String, type:ComplainType = .complain) {
        let vc = OrderComplainMainVc.cd_storyboard("Order", from: "OrderComplainMainVc") as! OrderComplainMainVc
        vc.orderId = orderid
        vc.viewType = type
        CD.push(vc)
    }
}

class OrderComplainMainVc: UIViewController {

    @IBOutlet weak var stackBgV: UIStackView!
    @IBOutlet weak var headerV: UIView!
    @IBOutlet weak var curSubV: UIView!
    
    lazy var topBar: CD_TopBar = {
        return CD_TopBar()
    }()
    
    var viewType:ComplainType = .complain
    var state = 0
    
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    var segmentedtTitles:[String] = ["申诉过程".languageString(), "申诉处理".languageString()]
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        segmentedDa.titles = segmentedtTitles
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = Config.color.hex("6")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = Config.color.hex("3")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = Config.color.hex("#478BFF")
        indicator.indicatorWidth = 40
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    var orderId = ""
    
    var siteComplainStat = 0
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        configUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.navigationController?.setNavigationBarHidden(true, animated: false)
        switch viewType {
        case .complain:
            segmentedtTitles = ["申诉过程".languageString(), "申诉处理".languageString()]
        case .complainCheck:
            segmentedtTitles = ["申诉过程".languageString(), "审核处理".languageString()]
        }
    }
    
    func configUI() {
        self.cd.navigationBar(hidden: true)
        self.view.cd
            .add(topBar)
        topBar.delegate = self
        
        stackBgV.snp.makeConstraints { make in
            make.top.equalTo(topBar.snp_bottom)
        }
        
        segmentedView.defaultSelectedIndex = state
        segmentedDataSource.reloadData(selectedIndex: state)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        headerV.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
        
        addSubViewControlls()
        
        view.addSubview(self.listContainerView)
        segmentedView.listContainer = listContainerView
        curSubV.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        do {
            let curViewC1 = UIStoryboard(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "OrderComplainProcessVc") as! OrderComplainProcessVc
            curViewC1.vm.orderId = orderId
            curViewC1.vm.callBack = {[weak self] stat in
                guard let weakSelf = self else { return }
                weakSelf.siteComplainStat = stat
            }
            cSubC.append(curViewC1)
        }
        
        do {
            let curViewC2 = UIStoryboard(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "OrderComplainHandlingVc") as! OrderComplainHandlingVc
            curViewC2.vm.orderId = orderId
            curViewC2.vm.viewType = viewType
            curViewC2.getStat = {[weak self] in
                guard let weakSelf = self else { return }
                curViewC2.siteComplainStat = weakSelf.siteComplainStat
            }
            cSubC.append(curViewC2)
        }
        
        subControllerList = cSubC
    }
    
    
    func setSelectIndex(_ idx:Int) {
        state = idx
        if !subControllerList.isEmpty {
            segmentedView.selectItemAt(index: state)
        }else{
            segmentedDataSource.reloadData(selectedIndex: state)
        }
    }
    
}

extension OrderComplainMainVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {

    }
}

extension OrderComplainMainVc: CD_TopBarProtocol {
    func topBarCustom() {
        topBar.snp.makeConstraints { (make) in
            make.left.top.right.equalToSuperview()
        }
        topBar._style = "10"
        
        topBar.cd.background(.white)
        switch viewType {
        case .complain:
            topBar._title = "工单申诉处理".languageString()
        case .complainCheck:
            topBar._title = "工单申诉审核".languageString()
        }
        topBar.bar_navigation.item_centre._colorTitle = Config.color.hex("3")
        topBar.bar_navigation.item_centre.btn_1.titleLabel?.font = Config.font.fontMedium(18)
        topBar.bar_navigation.line.cd.isHidden(false)
            .background(Config.color.hex("EC"))
    }
    
    func update(withTopBar item: CD_TopNavigationBar.Item) -> [CD_TopNavigationBarItem.Item.Style]? {
        switch item {
        case .leftItem1:
            let color:UIColor = Config.color.hex("6")
            let icon = CD_IconFont.tback_light(22)
            return [.title([(icon.text, icon.font, color, .normal), (icon.text, icon.font, Config.color.hex("6"), .highlighted), (icon.text, icon.font, Config.color.hex("6"), .selected)])]
        default:
            return nil
        }
    }
    
    func didSelect(withTopBar item: CD_TopNavigationBar.Item) {
        super_topBarClick(item)
        switch item {
        case .leftItem1:
            break
        default:
            break
        }
    }
}

