//
//  OrderHomeVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/8/22.
//

import UIKit
import JXSegmentedView

class OrderHomeVc: UIViewController {
    
    @IBOutlet weak var stack_bgV: UIStackView!
    @IBOutlet weak var headerView: UIView!
    @IBOutlet weak var curSubView: UIView!
    
    lazy var topBar: CD_TopBar = {
        return CD_TopBar()
    }()
    
    var curVC:WorkbenchVc?
    var state = 0
    
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    var segmentedtTitles:[String] = ["服务人员工作台".languageString(), "企业人员工作台".languageString()]
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        segmentedDa.titles = segmentedtTitles
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = Config.color.hex("6")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = Config.color.hex("3")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = Config.color.hex("#478BFF")
        indicator.indicatorWidth = 24
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        configUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.navigationController?.setNavigationBarHidden(true, animated: false)
        
    }
    
    func configUI() {
        self.cd.navigationBar(hidden: true)
        self.view.cd
            .add(topBar)
        topBar.delegate = self
        
        stack_bgV.snp.makeConstraints { make in
            make.left.bottom.right.equalToSuperview()
            make.top.equalTo(topBar.snp_bottom)
        }
        
        segmentedtTitles = []
        if !MyInfo.shareInstance().siteId.isEmpty {
            segmentedtTitles.append("服务人员工作台".languageString())
        }
        if !MyInfo.shareInstance().adminId.isEmpty {
            segmentedtTitles.append("企业人员工作台".languageString())
        }
        
        segmentedView.defaultSelectedIndex = state
        segmentedDataSource.reloadData(selectedIndex: state)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        headerView.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
        
        addSubViewControlls()
        setCurrentVC()
        
        view.addSubview(self.listContainerView)
        segmentedView.listContainer = listContainerView
        curSubView.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        if !MyInfo.shareInstance().siteId.isEmpty {
            do {
                let curViewC = UIStoryboard(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "WorkbenchVc") as! WorkbenchVc
                curViewC.vm.flushTable = 1
                cSubC.append(curViewC)
            }
        }
        
        if !MyInfo.shareInstance().adminId.isEmpty {
            do {
                let curViewC = UIStoryboard(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "WorkbenchVc") as! WorkbenchVc
                curViewC.vm.flushTable = 2
                cSubC.append(curViewC)
            }
        }
        
        subControllerList = cSubC
    }

    func setCurrentVC() {
        let vc = subControllerList[segmentedView.selectedIndex] as! WorkbenchVc
        curVC = vc
    }
    
    
    func setSelectIndex(_ idx:Int) {
        state = idx
        if !subControllerList.isEmpty {
            segmentedView.selectItemAt(index: state)
        }else{
            segmentedDataSource.reloadData(selectedIndex: state)
        }
    }
    
}

extension OrderHomeVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        let vc = subControllerList[index] as! WorkbenchVc
        curVC = vc
//        if vc.isViewLoaded {
//            vc.tableView.mj_header?.beginRefreshing()
//        }
        
    }
}

extension OrderHomeVc: CD_TopBarProtocol {
    func topBarCustom() {
        topBar.snp.makeConstraints { (make) in
            make.left.top.right.equalToSuperview()
        }
        
        topBar.cd.background(.white)
        topBar._title = "工作台".languageString()
        topBar.bar_navigation.item_centre._colorTitle = Config.color.hex("3")
        topBar.bar_navigation.item_centre.btn_1.titleLabel?.font = Config.font.fontMedium(18)
        topBar.bar_navigation.line.cd.isHidden(false)
            .background(Config.color.hex("EC"))
        topBar._leftItemsWidth1 = 0
    }
}
