//
//  OrderPartsApplyInfoVc.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/14.
//

import UIKit
import JXSegmentedView

class OrderPartsApplyInfoVc: UIViewController {

    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var btn_apply: UIButton!
    @IBOutlet weak var view_btns: UIView!
    @IBOutlet weak var btn_save: UIButton!
    @IBOutlet weak var lab_nil: UILabel!
    
    var vm = OrderPartsApplyInfoVm()
    
    var isSetDatas = false
    var callBack:((Bool)->Void)?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        lab_nil.text = "无配件申请记录".languageString()
        btn_apply.cd.text("申领配件".languageString())
        btn_save.cd.text("保存".languageString())
        makeUI()
        vm.makeForms()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        if vm.model.applyPartsMode == "2" {
            view_btns.cd.isHidden(vm.model.applyButton != "1")
            btn_save.cd.isHidden(true)
            btn_apply.cd.isHidden(vm.model.applyButton != "1")
        }else{
            view_btns.cd.isHidden(!["0","1"].contains(vm.model.stat) && vm.model.applyButton != "1")
            btn_save.cd.isHidden(!["0","1"].contains(vm.model.stat))
            btn_apply.cd.isHidden(vm.model.applyButton != "1")
        }
        
        if !isSetDatas {
            if !vm.model.pic1.isEmpty {
                vm.picArr.append(TCFormImageModel(imageUrl: vm.model.pic1))
            }
            if !vm.model.pic2.isEmpty {
                vm.picArr.append(TCFormImageModel(imageUrl: vm.model.pic2))
            }
            if !vm.model.pic3.isEmpty {
                vm.picArr.append(TCFormImageModel(imageUrl: vm.model.pic3))
            }
            vm.makeForms()
            isSetDatas = true
        }
    }

    func makeUI() {
        vm.reloadData = {[weak self] in
            guard let weakSelf = self else { return }
            if weakSelf.vm.model.applyPartsMode == "2" {
                weakSelf.tableView.cd.isHidden(weakSelf.vm.model.waitApplyPartsList.isEmpty)
            }else{
                weakSelf.tableView.cd.isHidden(weakSelf.vm.model.applyId.isEmpty)
            }
            weakSelf.tableView.reloadData()
        }

        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.showsVerticalScrollIndicator = false
        tableView.showsHorizontalScrollIndicator = false
    }
    
    @IBAction func clickbutton(_ sender: UIButton) {
        switch sender.titleLabel?.text {
        case "申领配件".languageString():
            R_OrderApplyParts.router(vm.orderId, vm.model.applyId, itemId: vm.itemId, applyPartsMode: vm.model.applyPartsMode, waitApplyPartsList: vm.model.waitApplyPartsList) { [weak self] bool in
                guard let weakSelf = self else { return }
                weakSelf.callBack?(bool)
            }
        case "保存".languageString():
            vm.saveData()
        default:
            break
        }
    }
}

extension OrderPartsApplyInfoVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}

extension OrderPartsApplyInfoVc:JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return self.view
    }
}
