//
//  OrderPartsInfoMainVc.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/14.
//

import UIKit
import JXSegmentedView

public struct R_OrderPartsInfoMain {
    static func router(_ orderid: String, itemId:String) {
        let vc = OrderPartsInfoMainVc.cd_storyboard("Order", from: "OrderPartsInfoMainVc") as! OrderPartsInfoMainVc
        vc.orderId = orderid
        vc.itemId = itemId
        CD.push(vc)
    }
}

class OrderPartsInfoMainVc: UIViewController {

    @IBOutlet weak var stackBgV: UIStackView!
    @IBOutlet weak var headerV: UIView!
    @IBOutlet weak var curSubV: UIView!
    
    lazy var topBar: CD_TopBar = {
        return CD_TopBar()
    }()
    
    var state = 0
    
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    var segmentedtTitles:[String] = ["配件申领".languageString(), "配件更换".languageString()]
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        segmentedDa.titles = segmentedtTitles
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = Config.color.hex("6")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = Config.color.hex("3")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = Config.color.hex("#478BFF")
        indicator.indicatorWidth = 40
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    var curViewC1 = OrderPartsApplyInfoVc()
    
    var orderId = ""
    var itemId = ""
    
    var model = M_OrderPartsInfo()
    override func viewDidLoad() {
        super.viewDidLoad()
        
        configUI()
        requestData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.navigationController?.setNavigationBarHidden(true, animated: false)
        
    }
    
    func configUI() {
        self.cd.navigationBar(hidden: true)
        self.view.cd
            .add(topBar)
        topBar.delegate = self
        
        stackBgV.snp.makeConstraints { make in
            make.top.equalTo(topBar.snp_bottom)
        }
        
        segmentedView.defaultSelectedIndex = state
        segmentedDataSource.reloadData(selectedIndex: state)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        headerV.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
        
        addSubViewControlls()
        
        view.addSubview(self.listContainerView)
        segmentedView.listContainer = listContainerView
        curSubV.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
        }
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        do {
            curViewC1 = UIStoryboard(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "OrderPartsApplyInfoVc") as! OrderPartsApplyInfoVc
            curViewC1.vm.orderId = orderId
            curViewC1.vm.itemId = itemId
            curViewC1.callBack = { [weak self] bool in
                guard let weakSelf = self else { return }
                weakSelf.requestData()
            }
            cSubC.append(curViewC1)
        }
        
        do {
            let curViewC2 = UIStoryboard(name: "Order", bundle: nil).instantiateViewController(withIdentifier: "OrderPartsReplaceListVc") as! OrderPartsReplaceListVc
            curViewC2.vm.orderId = orderId
            curViewC2.getData = {[weak self] in
                guard let weakSelf = self else { return }
                curViewC2.vm.models = weakSelf.model.orderPartsList
                curViewC2.vm.makeForms()
            }
            cSubC.append(curViewC2)
        }
        
        subControllerList = cSubC
    }
    
    
    func setSelectIndex(_ idx:Int) {
        state = idx
        if !subControllerList.isEmpty {
            segmentedView.selectItemAt(index: state)
        }else{
            segmentedDataSource.reloadData(selectedIndex: state)
        }
    }
    
}

extension OrderPartsInfoMainVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        if let vc = subControllerList[index] as? OrderPartsReplaceListVc {
            vc.vm.models = model.orderPartsList
            vc.vm.makeForms()
        }
    }
}

extension OrderPartsInfoMainVc {
    func requestData() {
        var par:[String:Any] = [:]
        par["orderId"] = orderId
        par["itemId"] = itemId
        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/partsDo/getOrderPartsInfo",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                weakSelf.model = M_OrderPartsInfo(data)
                weakSelf.curViewC1.vm.data = data
                weakSelf.curViewC1.vm.makeForms()
            }
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_hidden()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
}

extension OrderPartsInfoMainVc: CD_TopBarProtocol {
    func topBarCustom() {
        topBar.snp.makeConstraints { (make) in
            make.left.top.right.equalToSuperview()
        }
        topBar._style = "10"
        
        topBar.cd.background(.white)
        topBar._title = "配件信息".languageString()
        topBar.bar_navigation.item_centre._colorTitle = Config.color.hex("3")
        topBar.bar_navigation.item_centre.btn_1.titleLabel?.font = Config.font.fontMedium(18)
        topBar.bar_navigation.line.cd.isHidden(false)
            .background(Config.color.hex("EC"))
    }
    
    func update(withTopBar item: CD_TopNavigationBar.Item) -> [CD_TopNavigationBarItem.Item.Style]? {
        switch item {
        case .leftItem1:
            let color:UIColor = Config.color.hex("6")
            let icon = CD_IconFont.tback_light(22)
            return [.title([(icon.text, icon.font, color, .normal), (icon.text, icon.font, Config.color.hex("6"), .highlighted), (icon.text, icon.font, Config.color.hex("6"), .selected)])]
        default:
            return nil
        }
    }
    
    func didSelect(withTopBar item: CD_TopNavigationBar.Item) {
        super_topBarClick(item)
        switch item {
        case .leftItem1:
            break
        default:
            break
        }
    }
}

