//
//  OrderAssignUserVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/31.
//

import Foundation

class OrderAssignUserVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var models:[M_OrderAssignUser] = []
    var selModel = M_OrderAssignUser()
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        for (i,item) in models.enumerated() {
            newForms += makeLineCellForm()
            do {
                let rowCell = TCFormCellModel<OrderAssignUserCell>.init(data: item, frameh: UITableView.automaticDimension) {[weak self] _ in
                    guard let weakSelf = self else { return }
                    weakSelf.setSelect(i)
                }
                newForms.append(rowCell)
            }
        }
        newForms += makeLineCellForm(16)
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(_ height:CGFloat? = nil) -> [TCCellBaseProtocol] {
        var hh = height ?? 8
        let rowCell = TCFormCellModel<WorkbenchTitleCell>.init(data: "", config: ((0, []), true, true), frameh: hh)
        return [rowCell]
    }
    
    func setSelect(_ idx:Int)  {
        for (i,_) in models.enumerated() {
            if i == idx {
                models[i].isSelect = true
                selModel = models[i]
            }else{
                models[i].isSelect = false
            }
        }
        self.makeForms()
    }
}

extension OrderAssignUserVc {
    func getSiteList() {
        var par:[String:Any] = [:]
        par["orderId"] = orderId
        par["pageNumber"] = pageNumber
        par["pageSize"] = pageSize
//        par["searchKey"] = searchKey //查询关键字(搜索时传入的关键字)

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/getSiteList",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                if let list = data["list"] as? [[String:Any]] {
                    weakSelf.pageCount = list.count
                    if weakSelf.pageNumber == 1 {
                        weakSelf.vm.models = list.compactMap({M_OrderAssignUser($0)})
                    }else{
                        weakSelf.vm.models += list.compactMap({M_OrderAssignUser($0)})
                    }
                    weakSelf.vm.makeForms()
                }
            }
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_hidden()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
    
    func assinSite() {
        guard !vm.selModel.siteName.isEmpty else {
            hud_info("请选择服务商!".languageString())
            return
        }
        var par:[String:Any] = [:]
        par["orderId"] = orderId
        par["assignedSiteId"] = vm.selModel.siteId

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/assinSite",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_succeed("操作成功~".languageString())
            weakSelf.callBack?(true)
            weakSelf.popVC()
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_hidden()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
    
    func getEngineerList() {
        var par:[String:Any] = [:]
        par["orderId"] = orderId
        par["pageNumber"] = pageNumber
        par["pageSize"] = pageSize
//        par["searchKey"] = searchKey //查询关键字(搜索时传入的关键字)
        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/getEngineerList",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                if let list = data["list"] as? [[String:Any]] {
                    weakSelf.pageCount = list.count
                    if weakSelf.pageNumber == 1 {
                        weakSelf.vm.models = list.compactMap({M_OrderAssignUser($0)})
                    }else{
                        weakSelf.vm.models += list.compactMap({M_OrderAssignUser($0)})
                    }
                    weakSelf.vm.makeForms()
                }
            }
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_hidden()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
    
    func assinEngineer() {
        guard !vm.selModel.engineerName.isEmpty else {
            hud_info("请选择工程师!".languageString())
            return
        }
        var par:[String:Any] = [:]
        par["orderId"] = orderId
        par["assignedEngineerId"] = vm.selModel.engineerId
        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/assinEngineer",andParam: par)
        cNet.successCall = { [weak self] (result) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_succeed("操作成功~".languageString())
            weakSelf.callBack?(true)
            weakSelf.popVC()
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_hidden()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
}
