//
//  OrderAssistPersonVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/9.
//

import Foundation

class OrderAssistPersonVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var orderId = ""
    var searchKey = ""      //查询关键字(搜索时传入的关键字)
    var pageNumber = 1      //当前页
    var pageSize = 10        //每页大小
    var pageCount = 0
    
    var models:[M_OrderTransfer] = []
    var selModel = M_OrderTransfer()
    
    var selIdList:[String] = []
}

extension OrderAssistPersonVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        
        for (i,item) in models.enumerated(){
            newForms += makeLineCellForm(bgColor: Config.color.hex("f8"), height: 8)
            do{
                let rowCell = TCFormCellModel<OrderHelperCell>.init(data: item,frameh: UITableView.automaticDimension, didSelect:  {[weak self] in
                    guard let weakSelf = self else { return }
                    weakSelf.models[i].isSelect = !weakSelf.models[i].isSelect
                    let m = weakSelf.models[i]
                    if m.isSelect {
                        if !weakSelf.selIdList.contains(m.id) {
                            weakSelf.selIdList.append(m.id)
                        }
                    }else{
                        weakSelf.selIdList.removeAll(where: {$0 == m.id})
                    }
                    weakSelf.makeForms()
                })
                newForms.append(rowCell)
            }
        }
        newForms += makeLineCellForm(bgColor: Config.color.hex("f8"), height: 16)
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
}
extension OrderAssistPersonVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["orderId"] = orderId
        par["searchKey"] = searchKey
        par["pageNumber"] = pageNumber
        par["pageSize"] = pageSize

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/getHelperList",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                if let list = data["helperlist"] as? [[String:Any]] {
                    weakSelf.pageCount = list.count
                    if weakSelf.pageNumber == 1 {
                        weakSelf.models = list.compactMap({M_OrderTransfer($0, selArr: weakSelf.selIdList)})
                    }else{
                        weakSelf.models += list.compactMap({M_OrderTransfer($0, selArr: weakSelf.selIdList)})
                    }
                    weakSelf.makeForms()
                }
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}
