//
//  OrderCasePoolDetailVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/5.
//

import Foundation

class OrderCasePoolDetailVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var viewType = 0   //0、标准案例；1、案例工单
    
    var models: [M_OrderCasePool] = []
    
    var callBack:((String)->Void)?
    
    var caseDemoId = ""
    
    var model = M_OrderCasePoolDetail()
}

extension OrderCasePoolDetailVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeLineCellForm(bgColor: .white, backGroundColor: .white)
        do{
            let rowCell = TCFormCellModel<OrderDetailTitleCell>.init(data: ("\("工单号".languageString()) \(model.caseNo)", ""), config: ((CGFloat(8),UIRectCorner(arrayLiteral: [.topLeft, .topRight])), Config.color.hex("#478BFF").cd_alpha(0.1), UIColor.white), frameh: UITableView.automaticDimension)
            newForms.append(rowCell)
        }
        newForms += makeLineCellForm(leftW: 12, rightW: 12,bgColor: Config.color.hex("#478BFF").cd_alpha(0.2),backGroundColor: .white, height: 0.5)
        newForms += makeLineCellForm(leftW: 12, rightW: 12,bgColor: Config.color.hex("#478BFF").cd_alpha(0.1),backGroundColor: .white)
        newForms += makeInfoCellForm(titleStr: "故障描述".languageString(), detailStr: model.fault)
        newForms += makeLineCellForm(leftW: 12, rightW: 12,bgColor: Config.color.hex("#478BFF").cd_alpha(0.1),backGroundColor: .white, height: 8)
        newForms += makeInfoCellForm(titleStr: "产品分类".languageString(), detailStr: model.category)
        newForms += makeLineCellForm(leftW: 12, rightW: 12,bgColor: Config.color.hex("#478BFF").cd_alpha(0.1),backGroundColor: .white, height: 8)
        newForms += makeInfoCellForm(titleStr: "发布时间".languageString(), detailStr: model.createTime)
        newForms += makeLineCellForm(leftW: 12, rightW: 12,bgColor: Config.color.hex("#478BFF").cd_alpha(0.1),backGroundColor: .white,corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]), height: 12)
        newForms += makeLineCellForm(bgColor: .white, backGroundColor: .white)
        newForms += makeLineCellForm(bgColor: Config.color.hex("f8"))
        do{
            let rowCell = TCFormCellModel<OrderCasePoolHtmlCell>.init(data: (model.content), frameh: UITableView.automaticDimension)
            newForms.append(rowCell)
        }
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
    
    func makeTitleCellForm(titleStr:String = "", statusStr:String = "", corner:(CGFloat, UIRectCorner) = (0,[]), hh:CGFloat? = nil) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderDetailTitleCell>.init(data: (titleStr, statusStr), config: corner, frameh: hh ?? UITableView.automaticDimension)
        return [rowCell]
    }
    
    func makeInfoCellForm(titleStr:String, detailStr:String, hh:CGFloat? = nil) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderDetailInfoCell>.init(data: (titleStr, detailStr), config: (Config.color.hex("478BFF").cd_alpha(0.1), UIColor.white), frameh: hh ?? UITableView.automaticDimension)
        return [rowCell]
    }
}
extension OrderCasePoolDetailVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["caseDemoId"] = caseDemoId
        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/getCaseDemoDetail",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                weakSelf.model = M_OrderCasePoolDetail(data)
                weakSelf.makeForms()
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}

class M_OrderCasePoolDetail: NSObject {
    var caseId = ""       //标准案例ID
    var caseNo = ""       //标准案例编码
    var fault = ""       //故障描述
    var category = ""       //产品分类
    var createTime = ""       //发布时间
    var content = ""       //详情(富文本形式)

    init(_ data:[String:Any] = [:]) {
        caseId = data.stringValue(forKey: "caseId")
        caseNo = data.stringValue(forKey: "caseNo")
        fault = data.stringValue(forKey: "fault")
        category = data.stringValue(forKey: "category")
        createTime = data.stringValue(forKey: "createTime")
        content = data.stringValue(forKey: "content")
    }
}
